/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.idp;

import java.util.LinkedList;
import java.util.List;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.services.ClientRegistration;
import org.apache.cxf.rs.security.oauth2.services.ClientRegistrationResponse;
import org.apache.cxf.rs.security.oauth2.services.DynamicRegistrationService;

public class OidcDynamicRegistrationService
extends DynamicRegistrationService {
    private static final String POST_LOGOUT_LOGOUT_URIS = "post_logout_redirect_uris";
    private static final String BACK_CHANNEL_LOGOUT_URI = "backchannel_logout_uri";
    private boolean protectIdTokenWithClientSecret;

    protected Client createNewClient(ClientRegistration request) {
        String backChannelLogoutUri;
        Client client = super.createNewClient(request);
        List postLogoutUris = request.getListStringProperty(POST_LOGOUT_LOGOUT_URIS);
        if (postLogoutUris != null) {
            StringBuilder sb = new StringBuilder();
            for (String uri : postLogoutUris) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(uri);
            }
            client.getProperties().put(POST_LOGOUT_LOGOUT_URIS, sb.toString());
        }
        if ((backChannelLogoutUri = request.getStringProperty(BACK_CHANNEL_LOGOUT_URI)) != null) {
            client.getProperties().put(BACK_CHANNEL_LOGOUT_URI, backChannelLogoutUri);
        }
        return client;
    }

    protected ClientRegistrationResponse fromClientToRegistrationResponse(Client client) {
        return super.fromClientToRegistrationResponse(client);
    }

    protected ClientRegistration fromClientToClientRegistration(Client client) {
        ClientRegistration resp = super.fromClientToClientRegistration(client);
        String logoutUris = (String)client.getProperties().get(POST_LOGOUT_LOGOUT_URIS);
        if (logoutUris != null) {
            LinkedList<String> list = new LinkedList<String>();
            for (String s : logoutUris.split(" ")) {
                list.add(s);
            }
            resp.setProperty(POST_LOGOUT_LOGOUT_URIS, list);
        }
        return resp;
    }

    protected int getClientSecretSizeInBytes(ClientRegistration request) {
        int keySizeOctets = this.protectIdTokenWithClientSecret ? 32 : super.getClientSecretSizeInBytes(request);
        return keySizeOctets;
    }

    public void setProtectIdTokenWithClientSecret(boolean protectIdTokenWithClientSecret) {
        this.protectIdTokenWithClientSecret = protectIdTokenWithClientSecret;
    }
}

