/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.net.URI;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.BulkAction;
import org.apache.syncope.common.lib.to.BulkActionResult;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.to.TaskTO;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.rest.api.beans.TaskQuery;
import org.apache.syncope.common.rest.api.service.TaskService;
import org.apache.syncope.core.logic.AbstractExecutableLogic;
import org.apache.syncope.core.logic.TaskLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractExecutableService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskServiceImpl
extends AbstractExecutableService
implements TaskService {
    @Autowired
    private TaskLogic logic;

    @Override
    protected AbstractExecutableLogic<?> getExecutableLogic() {
        return this.logic;
    }

    public Response create(TaskType type, SchedTaskTO taskTO) {
        if (taskTO == null) {
            throw new BadRequestException();
        }
        SchedTaskTO createdTask = this.logic.createSchedTask(type, taskTO);
        URI location = this.uriInfo.getAbsolutePathBuilder().path(createdTask.getKey()).build(new Object[0]);
        return Response.created((URI)location).header("X-Syncope-Key", (Object)createdTask.getKey()).build();
    }

    public void delete(TaskType type, String key) {
        this.logic.delete(type, key);
    }

    public <T extends TaskTO> PagedResult<T> search(TaskQuery query) {
        Pair result = this.logic.search(query.getType(), query.getResource(), query.getNotification(), query.getAnyTypeKind(), query.getEntityKey(), query.getPage().intValue(), query.getSize().intValue(), this.getOrderByClauses(query.getOrderBy()), query.getDetails().booleanValue());
        return this.buildPagedResult((List)result.getRight(), query.getPage(), query.getSize(), (Integer)result.getLeft());
    }

    public <T extends TaskTO> T read(TaskType type, String key, boolean details) {
        return (T)this.logic.read(type, key, details);
    }

    public void update(TaskType type, SchedTaskTO taskTO) {
        this.logic.updateSchedTask(type, taskTO);
    }

    public BulkActionResult bulk(BulkAction bulkAction) {
        BulkActionResult result = new BulkActionResult();
        switch (bulkAction.getType()) {
            case DELETE: {
                for (String key : bulkAction.getTargets()) {
                    try {
                        result.getResults().put(this.logic.delete(null, key).getKey(), BulkActionResult.Status.SUCCESS);
                    }
                    catch (Exception e) {
                        LOG.error("Error performing delete for task {}", (Object)key, (Object)e);
                        result.getResults().put(key, BulkActionResult.Status.FAILURE);
                    }
                }
                break;
            }
            case DRYRUN: {
                for (String key : bulkAction.getTargets()) {
                    try {
                        this.logic.execute(key, null, true);
                        result.getResults().put(key, BulkActionResult.Status.SUCCESS);
                    }
                    catch (Exception e) {
                        LOG.error("Error performing dryrun for task {}", (Object)key, (Object)e);
                        result.getResults().put(key, BulkActionResult.Status.FAILURE);
                    }
                }
                break;
            }
            case EXECUTE: {
                for (String key : bulkAction.getTargets()) {
                    try {
                        this.logic.execute(key, null, false);
                        result.getResults().put(key, BulkActionResult.Status.SUCCESS);
                    }
                    catch (Exception e) {
                        LOG.error("Error performing execute for task {}", (Object)key, (Object)e);
                        result.getResults().put(key, BulkActionResult.Status.FAILURE);
                    }
                }
                break;
            }
        }
        return result;
    }
}

