/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.OIDCProvider;
import org.apache.syncope.core.persistence.api.entity.OIDCProviderItem;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.OIDCProviderCheck;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;

public class OIDCProviderValidator
extends AbstractValidator<OIDCProviderCheck, OIDCProvider> {
    public boolean isValid(OIDCProvider value, ConstraintValidatorContext context) {
        if (value.isSelfRegUnmatching() && value.isCreateUnmatching()) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.Standard, "Either selfRegUnmatching or createUnmatching, not both")).addPropertyNode("selfRegUnmatching").addPropertyNode("createUnmatching").addConstraintViolation();
            return false;
        }
        long connObjectKeys = IterableUtils.countMatches((Iterable)value.getItems(), (Predicate)new Predicate<OIDCProviderItem>(){

            public boolean evaluate(OIDCProviderItem item) {
                return item.isConnObjectKey();
            }
        });
        if (!value.getItems().isEmpty() && connObjectKeys != 1L) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidMapping, "Single ConnObjectKey mapping is required")).addPropertyNode("connObjectKey.size").addConstraintViolation();
            return false;
        }
        boolean isValid = true;
        long passwords = IterableUtils.countMatches((Iterable)value.getItems(), (Predicate)new Predicate<OIDCProviderItem>(){

            public boolean evaluate(OIDCProviderItem item) {
                return item.isPassword();
            }
        });
        if (passwords > 0L) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidMapping, "No password mapping is allowed")).addPropertyNode("password.size").addConstraintViolation();
            isValid = false;
        }
        for (OIDCProviderItem item : value.getItems()) {
            for (String className : item.getTransformerClassNames()) {
                Class<?> actionsClass = null;
                boolean isAssignable = false;
                try {
                    actionsClass = Class.forName(className);
                    isAssignable = ItemTransformer.class.isAssignableFrom(actionsClass);
                }
                catch (Exception e) {
                    LOG.error("Invalid MappingItemTransformer specified: {}", (Object)className, (Object)e);
                }
                if (actionsClass != null && isAssignable) continue;
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidMapping, "Invalid mapping item trasformer class name")).addPropertyNode("mappingItemTransformerClassName").addConstraintViolation();
                isValid = false;
            }
        }
        return isValid;
    }
}

