/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.OIDCProviderDAO;
import org.apache.syncope.core.persistence.api.entity.OIDCProvider;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAOIDCProvider;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JPAOIDCProviderDAO
extends AbstractDAO<OIDCProvider>
implements OIDCProviderDAO {
    @Transactional(readOnly=true)
    public OIDCProvider find(String key) {
        return (OIDCProvider)this.entityManager().find(JPAOIDCProvider.class, (Object)key);
    }

    @Transactional(readOnly=true)
    public OIDCProvider findByName(String name) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAOIDCProvider.class.getSimpleName() + " e WHERE e.name = :name", OIDCProvider.class);
        query.setParameter("name", (Object)name);
        OIDCProvider result = null;
        try {
            result = (OIDCProvider)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOG.debug("No OIDC Provider found with name {}", (Object)name, (Object)e);
        }
        return result;
    }

    @Transactional(readOnly=true)
    public List<OIDCProvider> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAOIDCProvider.class.getSimpleName() + " e", OIDCProvider.class);
        return query.getResultList();
    }

    public OIDCProvider save(OIDCProvider op) {
        return (OIDCProvider)this.entityManager().merge((Object)op);
    }

    public void delete(String key) {
        OIDCProvider op = this.find(key);
        if (op != null) {
            this.entityManager().remove((Object)op);
        }
    }
}

