/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.install;

import java.io.FileNotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.install.InstallResultManager;
import org.apache.syncope.client.cli.commands.install.InstallSetup;
import org.apache.syncope.client.cli.commands.install.InstallSetupForDebug;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="install")
public class InstallCommand
extends AbstractCommand {
    private static final Logger LOG = LoggerFactory.getLogger(InstallCommand.class);
    private final InstallResultManager installResultManager = new InstallResultManager();
    private static final String HELP_MESSAGE = "\nUsage: install [options]\n  Options:\n    --help \n    --setup\n    --setup-debug\n";

    @Override
    public void execute(Input input) {
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(Options.HELP.getOptionName());
        }
        switch (Options.fromName(input.getOption())) {
            case SETUP: {
                try {
                    new InstallSetup().setup();
                }
                catch (FileNotFoundException | IllegalAccessException ex) {
                    LOG.error("Error installing CLI", (Throwable)ex);
                    this.installResultManager.genericError(ex.getMessage());
                }
                break;
            }
            case SETUP_DEBUG: {
                try {
                    new InstallSetupForDebug().setup();
                }
                catch (FileNotFoundException | IllegalAccessException ex) {
                    LOG.error("Error installing CLI", (Throwable)ex);
                    this.installResultManager.genericError(ex.getMessage());
                }
                break;
            }
            case HELP: {
                System.out.println(HELP_MESSAGE);
                break;
            }
            default: {
                this.installResultManager.defaultOptionMessage(input.getOption(), HELP_MESSAGE);
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return HELP_MESSAGE;
    }

    public static enum Options {
        HELP("--help"),
        SETUP("--setup"),
        SETUP_DEBUG("--setup-debug");

        private final String optionName;

        private Options(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static Options fromName(String name) {
            Options optionToReturn = HELP;
            for (Options option : Options.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }
    }
}

