/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.ResponseHeader;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.PATCH;
import org.apache.syncope.common.lib.patch.StatusPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Api(tags={"UserSelf"})
@Path(value="users/self")
public interface UserSelfService
extends JAXRSService {
    @ApiOperation(value="", authorizations={@Authorization(value="BasicAuthentication"), @Authorization(value="Bearer")})
    @ApiResponses(value={@ApiResponse(code=200, message="Calling user data, including own UUID and entitlements", response=UserTO.class, responseHeaders={@ResponseHeader(name="X-Syncope-Key", response=String.class, description="UUID of the calling user"), @ResponseHeader(name="X-Syncope-Entitlements", response=String.class, description="List of entitlements owned by the calling user")})})
    @GET
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response read();

    @ApiImplicitParams(value={@ApiImplicitParam(name="Prefer", paramType="header", dataType="string", value="Allows the client to specify a preference for the result to be returned from the server", defaultValue="return-content", allowableValues="return-content, return-no-content", allowEmptyValue=true)})
    @ApiResponses(value={@ApiResponse(code=201, message="User successfully created enriched with propagation status information, as Entity,or empty if 'Prefer: return-no-content' was specified", response=ProvisioningResult.class, responseHeaders={@ResponseHeader(name="X-Syncope-Key", response=String.class, description="UUID generated for the user created"), @ResponseHeader(name="Location", response=String.class, description="URL of the user created"), @ResponseHeader(name="Preference-Applied", response=String.class, description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @POST
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response create(@NotNull UserTO var1, @DefaultValue(value="true") @QueryParam(value="storePassword") boolean var2);

    @ApiOperation(value="", authorizations={@Authorization(value="BasicAuthentication"), @Authorization(value="Bearer")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Prefer", paramType="header", dataType="string", value="Allows the client to specify a preference for the result to be returned from the server", defaultValue="return-content", allowableValues="return-content, return-no-content", allowEmptyValue=true), @ApiImplicitParam(name="key", paramType="path", dataType="string", value="User's key")})
    @ApiResponses(value={@ApiResponse(code=200, message="User successfully updated enriched with propagation status information, as Entity", response=ProvisioningResult.class), @ApiResponse(code=204, message="No content if 'Prefer: return-no-content' was specified", responseHeaders={@ResponseHeader(name="Preference-Applied", response=String.class, description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @PATCH
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response update(@NotNull UserPatch var1);

    @ApiOperation(value="", authorizations={@Authorization(value="BasicAuthentication"), @Authorization(value="Bearer")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Prefer", paramType="header", dataType="string", value="Allows the client to specify a preference for the result to be returned from the server", defaultValue="return-content", allowableValues="return-content, return-no-content", allowEmptyValue=true), @ApiImplicitParam(name="key", paramType="path", dataType="string", value="User's key")})
    @ApiResponses(value={@ApiResponse(code=200, message="User successfully updated enriched with propagation status information, as Entity", response=ProvisioningResult.class), @ApiResponse(code=204, message="No content if 'Prefer: return-no-content' was specified", responseHeaders={@ResponseHeader(name="Preference-Applied", response=String.class, description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @PUT
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response update(@NotNull UserTO var1);

    @ApiOperation(value="", authorizations={@Authorization(value="BasicAuthentication"), @Authorization(value="Bearer")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Prefer", paramType="header", dataType="string", value="Allows the client to specify a preference for the result to be returned from the server", defaultValue="return-content", allowableValues="return-content, return-no-content", allowEmptyValue=true), @ApiImplicitParam(name="key", paramType="path", dataType="string", value="User's key")})
    @ApiResponses(value={@ApiResponse(code=200, message="User successfully updated enriched with propagation status information, as Entity", response=ProvisioningResult.class), @ApiResponse(code=204, message="No content if 'Prefer: return-no-content' was specified", responseHeaders={@ResponseHeader(name="Preference-Applied", response=String.class, description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @POST
    @Path(value="{key}/status")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response status(@NotNull StatusPatch var1);

    @ApiOperation(value="", authorizations={@Authorization(value="BasicAuthentication"), @Authorization(value="Bearer")})
    @DELETE
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response delete();

    @ApiOperation(value="", authorizations={@Authorization(value="BasicAuthentication"), @Authorization(value="Bearer")})
    @POST
    @Path(value="mustChangePassword")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response mustChangePassword(String var1);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @POST
    @Path(value="requestPasswordReset")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void requestPasswordReset(@NotNull @QueryParam(value="username") String var1, String var2);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @POST
    @Path(value="confirmPasswordReset")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void confirmPasswordReset(@NotNull @QueryParam(value="token") String var1, String var2);
}

