/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.lib;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.staxutils.DocumentDepthProperties;
import org.apache.syncope.client.lib.AuthenticationHandler;
import org.apache.syncope.client.lib.BasicAuthenticationHandler;
import org.apache.syncope.client.lib.JWTAuthenticationHandler;
import org.apache.syncope.client.lib.NoAuthenticationHandler;
import org.apache.syncope.client.lib.RestClientExceptionMapper;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.rest.api.DateParamConverterProvider;

public class SyncopeClientFactoryBean {
    private JacksonJaxbJsonProvider jsonProvider;
    private JAXBElementProvider<?> jaxbProvider;
    private RestClientExceptionMapper exceptionMapper;
    private String address;
    private ContentType contentType;
    private String domain;
    private boolean useCompression;
    private JAXRSClientFactoryBean restClientFactoryBean;

    protected JacksonJaxbJsonProvider defaultJsonProvider() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JodaModule());
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        return new JacksonJaxbJsonProvider(objectMapper, JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS);
    }

    protected JAXBElementProvider<?> defaultJAXBProvider() {
        JAXBElementProvider defaultJAXBProvider = new JAXBElementProvider();
        DocumentDepthProperties depthProperties = new DocumentDepthProperties();
        depthProperties.setInnerElementCountThreshold(500);
        defaultJAXBProvider.setDepthProperties(depthProperties);
        HashMap<String, Boolean> marshallerProperties = new HashMap<String, Boolean>();
        marshallerProperties.put("jaxb.formatted.output", Boolean.TRUE);
        defaultJAXBProvider.setMarshallerProperties(marshallerProperties);
        HashMap<String, String> collectionWrapperMap = new HashMap<String, String>();
        collectionWrapperMap.put(PolicyTO.class.getName(), "policies");
        defaultJAXBProvider.setCollectionWrapperMap(collectionWrapperMap);
        return defaultJAXBProvider;
    }

    protected RestClientExceptionMapper defaultExceptionMapper() {
        return new RestClientExceptionMapper();
    }

    protected JAXRSClientFactoryBean defaultRestClientFactoryBean() {
        JAXRSClientFactoryBean defaultRestClientFactoryBean = new JAXRSClientFactoryBean();
        defaultRestClientFactoryBean.setHeaders(new HashMap());
        if (StringUtils.isBlank((CharSequence)this.address)) {
            throw new IllegalArgumentException("Property 'address' is missing");
        }
        defaultRestClientFactoryBean.setAddress(this.address);
        if (StringUtils.isNotBlank((CharSequence)this.domain)) {
            defaultRestClientFactoryBean.getHeaders().put("X-Syncope-Domain", Collections.singletonList(this.domain));
        }
        defaultRestClientFactoryBean.setThreadSafe(true);
        defaultRestClientFactoryBean.setInheritHeaders(true);
        ArrayList<LoggingFeature> features = new ArrayList<LoggingFeature>();
        features.add(new LoggingFeature());
        defaultRestClientFactoryBean.setFeatures(features);
        ArrayList<Object> providers = new ArrayList<Object>(4);
        providers.add(new DateParamConverterProvider());
        providers.add(this.getJaxbProvider());
        providers.add(this.getJsonProvider());
        providers.add(this.getExceptionMapper());
        defaultRestClientFactoryBean.setProviders(providers);
        return defaultRestClientFactoryBean;
    }

    public JacksonJaxbJsonProvider getJsonProvider() {
        return this.jsonProvider == null ? this.defaultJsonProvider() : this.jsonProvider;
    }

    public void setJsonProvider(JacksonJaxbJsonProvider jsonProvider) {
        this.jsonProvider = jsonProvider;
    }

    public JAXBElementProvider<?> getJaxbProvider() {
        return this.jaxbProvider == null ? this.defaultJAXBProvider() : this.jaxbProvider;
    }

    public SyncopeClientFactoryBean setJaxbProvider(JAXBElementProvider<?> jaxbProvider) {
        this.jaxbProvider = jaxbProvider;
        return this;
    }

    public RestClientExceptionMapper getExceptionMapper() {
        return this.exceptionMapper == null ? this.defaultExceptionMapper() : this.exceptionMapper;
    }

    public SyncopeClientFactoryBean setExceptionMapper(RestClientExceptionMapper exceptionMapper) {
        this.exceptionMapper = exceptionMapper;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public SyncopeClientFactoryBean setAddress(String address) {
        this.address = address;
        return this;
    }

    public ContentType getContentType() {
        return this.contentType == null ? ContentType.JSON : this.contentType;
    }

    public SyncopeClientFactoryBean setContentType(ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public SyncopeClientFactoryBean setContentType(String contentType) {
        this.contentType = ContentType.fromString(contentType);
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public SyncopeClientFactoryBean setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public SyncopeClientFactoryBean setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
        return this;
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }

    public JAXRSClientFactoryBean getRestClientFactoryBean() {
        return this.restClientFactoryBean == null ? this.defaultRestClientFactoryBean() : this.restClientFactoryBean;
    }

    public SyncopeClientFactoryBean setRestClientFactoryBean(JAXRSClientFactoryBean restClientFactoryBean) {
        this.restClientFactoryBean = restClientFactoryBean;
        return this;
    }

    public SyncopeClient create() {
        return this.create(new NoAuthenticationHandler());
    }

    public SyncopeClient create(String username, String password) {
        return this.create(new BasicAuthenticationHandler(username, password));
    }

    public SyncopeClient create(String jwt) {
        return this.create(new JWTAuthenticationHandler(jwt));
    }

    public SyncopeClient create(AuthenticationHandler handler) {
        return new SyncopeClient(this.getContentType().getMediaType(), this.getRestClientFactoryBean(), this.getExceptionMapper(), handler, this.useCompression);
    }

    public static enum ContentType {
        JSON(MediaType.APPLICATION_JSON_TYPE),
        YAML(SyncopeConstants.APPLICATION_YAML_TYPE),
        XML(MediaType.APPLICATION_XML_TYPE);

        private final MediaType mediaType;

        private ContentType(MediaType mediaType) {
            this.mediaType = mediaType;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        public static ContentType fromString(String value) {
            return XML.getMediaType().toString().equalsIgnoreCase(value) ? XML : (YAML.getMediaType().toString().equalsIgnoreCase(value) ? YAML : JSON);
        }
    }
}

