/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ide.eclipse.plugin.views;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.List;
import java.util.Scanner;
import javax.ws.rs.ProcessingException;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.MailTemplateTO;
import org.apache.syncope.common.lib.to.ReportTemplateTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MailTemplateFormat;
import org.apache.syncope.common.lib.types.ReportTemplateFormat;
import org.apache.syncope.common.rest.api.service.MailTemplateService;
import org.apache.syncope.common.rest.api.service.ReportTemplateService;
import org.apache.syncope.ide.eclipse.plugin.dialogs.AddTemplateDialog;
import org.apache.syncope.ide.eclipse.plugin.dialogs.LoginDialog;
import org.apache.syncope.ide.eclipse.plugin.editors.TemplateEditorInput;
import org.apache.syncope.ide.eclipse.plugin.views.TreeObject;
import org.apache.syncope.ide.eclipse.plugin.views.TreeParent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class SyncopeView
extends ViewPart {
    public static final String ID = "org.apache.syncope.ide.eclipse.plugin.views.SyncopeView";
    private TreeViewer viewer;
    private ViewContentProvider vcp;
    private static SyncopeClient SYNCOPE_CLIENT;
    private Action loginAction;
    private Action refreshAction;
    private Action doubleClickAction;
    private Action addAction;
    private Action readAction;
    private Action removeAction;
    private static final String MAIL_TEMPLATE_LABEL = "Mail Templates";
    private static final String REPORT_TEMPLATE_LABEL = "Report Templates";
    private static final String LOGIN_ACTION_TEXT = "Login";
    private static final String LOGIN_ACTION_TOOLTIP_TEXT = "Set Apache Syncope deployment url and login";
    private static final String REFRESH_ACTION_TEXT = "Refresh";
    private static final String REFRESH_ACTION_TOOLTIP_TEXT = "Refresh the template listings";
    private static final String READ_ACTION_TEXT = "View Template";
    private static final String ADD_ACTION_TEXT = "Add Template";
    private static final String REMOVE_ACTION_TEXT = "Remove template";
    private static final String LOADING_TEMPLATE_FORMAT_LABEL = "Loading template data";
    private static final String LOADING_TEMPLATE_LABEL = "Loading Templates";
    private static final String HELP_TEXT = "org.apache.syncope.ide.eclipse.plugin.viewer";
    public static final String TEMPLATE_FORMAT_HTML = "HTML";
    public static final String TEMPLATE_FORMAT_XSL_HTML = "XSL-HTML";
    public static final String TEMPLATE_FORMAT_CSV = "CSV";
    public static final String TEMPLATE_FORMAT_XSL_FO = "XSL-FO";
    public static final String TEMPLATE_FORMAT_TEXT = "TEXT";

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.vcp = new ViewContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.vcp);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setInput((Object)this.getViewSite());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), HELP_TEXT);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SyncopeView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.loginAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        ISelection selection = this.viewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof TreeParent) {
            manager.add((IAction)this.addAction);
        } else {
            manager.add((IAction)this.readAction);
            manager.add((IAction)this.removeAction);
        }
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.loginAction);
        this.refreshAction.setEnabled(false);
        manager.add((IAction)this.refreshAction);
    }

    private void makeActions() {
        this.loginAction = new Action(){

            public void run() {
                Shell shell = SyncopeView.this.viewer.getControl().getShell();
                LoginDialog dialog = new LoginDialog(shell);
                dialog.create();
                if (dialog.open() == 0) {
                    String deploymentUrl = dialog.getDeploymentUrl();
                    String username = dialog.getUsername();
                    String password = dialog.getPassword();
                    SyncopeView.this.vcp.deploymentUrl = deploymentUrl;
                    SyncopeView.this.vcp.username = username;
                    SyncopeView.this.vcp.password = password;
                    SyncopeView.this.updateTreeViewer();
                }
            }
        };
        this.loginAction.setText(LOGIN_ACTION_TEXT);
        this.loginAction.setToolTipText(LOGIN_ACTION_TOOLTIP_TEXT);
        this.refreshAction = new Action(){

            public void run() {
                SyncopeView.this.updateTreeViewer();
            }
        };
        this.refreshAction.setText(REFRESH_ACTION_TEXT);
        this.refreshAction.setToolTipText(REFRESH_ACTION_TOOLTIP_TEXT);
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = SyncopeView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (!(obj instanceof TreeParent)) {
                    SyncopeView.this.openTemplateInEditor((TreeObject)obj);
                } else {
                    SyncopeView.this.viewer.expandToLevel(obj, 1);
                }
            }
        };
        this.readAction = new Action(){

            public void run() {
                ISelection selection = SyncopeView.this.viewer.getSelection();
                TreeObject obj = (TreeObject)((IStructuredSelection)selection).getFirstElement();
                SyncopeView.this.openTemplateInEditor(obj);
            }
        };
        this.readAction.setText(READ_ACTION_TEXT);
        this.addAction = new Action(){

            public void run() {
                block6: {
                    ISelection selection = SyncopeView.this.viewer.getSelection();
                    TreeParent tp = (TreeParent)((IStructuredSelection)selection).getFirstElement();
                    Shell shell = SyncopeView.this.viewer.getControl().getShell();
                    AddTemplateDialog addTemplateDialog = new AddTemplateDialog(shell);
                    addTemplateDialog.create();
                    if (addTemplateDialog.open() == 0) {
                        String key = addTemplateDialog.getKey();
                        try {
                            if (tp.getName().equals(SyncopeView.MAIL_TEMPLATE_LABEL)) {
                                MailTemplateService mailTemplateService = (MailTemplateService)SYNCOPE_CLIENT.getService(MailTemplateService.class);
                                MailTemplateTO mtto = new MailTemplateTO();
                                mtto.setKey(key);
                                mailTemplateService.create(mtto);
                            } else if (tp.getName().equals(SyncopeView.REPORT_TEMPLATE_LABEL)) {
                                ReportTemplateService reportTemplateService = (ReportTemplateService)SYNCOPE_CLIENT.getService(ReportTemplateService.class);
                                ReportTemplateTO rtto = new ReportTemplateTO();
                                rtto.setKey(key);
                                reportTemplateService.create(rtto);
                            }
                            SyncopeView.this.updateTreeViewer();
                        }
                        catch (SyncopeClientException e) {
                            if (!e.toString().contains("EntityExists")) break block6;
                            MessageDialog.openError((Shell)shell, (String)"Template already exists", (String)("A template named " + key + " already exists."));
                        }
                    }
                }
            }
        };
        this.addAction.setText(ADD_ACTION_TEXT);
        this.removeAction = new Action(){

            public void run() {
                ISelection selection = SyncopeView.this.viewer.getSelection();
                TreeObject obj = (TreeObject)((IStructuredSelection)selection).getFirstElement();
                TreeParent tp = (TreeParent)SyncopeView.this.vcp.getParent(obj);
                if (SyncopeView.MAIL_TEMPLATE_LABEL.equals(tp.getName())) {
                    MailTemplateService mailTemplateService = (MailTemplateService)SYNCOPE_CLIENT.getService(MailTemplateService.class);
                    mailTemplateService.delete(obj.getName());
                } else if (tp.getName().equals(SyncopeView.REPORT_TEMPLATE_LABEL)) {
                    ReportTemplateService reportTemplateService = (ReportTemplateService)SYNCOPE_CLIENT.getService(ReportTemplateService.class);
                    reportTemplateService.delete(obj.getName());
                }
                SyncopeView.this.updateTreeViewer();
            }
        };
        this.removeAction.setText(REMOVE_ACTION_TEXT);
    }

    protected void openTemplateInEditor(final TreeObject obj) {
        TreeParent tp = (TreeParent)this.vcp.getParent(obj);
        if (MAIL_TEMPLATE_LABEL.equals(tp.getName())) {
            final MailTemplateService mailTemplateService = (MailTemplateService)SYNCOPE_CLIENT.getService(MailTemplateService.class);
            final String[] templateData = new String[2];
            final String[] editorTitles = new String[]{TEMPLATE_FORMAT_HTML, TEMPLATE_FORMAT_TEXT};
            final String[] editorToolTips = new String[]{obj.getName(), obj.getName()};
            Job job = new Job(LOADING_TEMPLATE_FORMAT_LABEL){

                protected IStatus run(IProgressMonitor arg0) {
                    templateData[0] = this.getStringFromTemplate(mailTemplateService, obj.getName(), MailTemplateFormat.HTML);
                    templateData[1] = this.getStringFromTemplate(mailTemplateService, obj.getName(), MailTemplateFormat.TEXT);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SyncopeView.this.getViewSite().getPage().openEditor((IEditorInput)new TemplateEditorInput(templateData, editorTitles, editorToolTips), "org.apache.syncope.ide.eclipse.plugin.editors.TemplateEditor");
                            }
                            catch (PartInitException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }

                private String getStringFromTemplate(MailTemplateService mailTemplateService2, String name, MailTemplateFormat format) {
                    try {
                        InputStream inpstream = (InputStream)mailTemplateService2.getFormat(name, format).getEntity();
                        Scanner sc = new Scanner(inpstream);
                        String templateContent = sc.nextLine();
                        while (sc.hasNext()) {
                            templateContent = String.valueOf(templateContent) + "\n" + sc.nextLine();
                        }
                        sc.close();
                        return templateContent;
                    }
                    catch (SyncopeClientException e) {
                        if (ClientExceptionType.NotFound.equals((Object)e.getType())) {
                            return "";
                        }
                        return null;
                    }
                }
            };
            job.setUser(true);
            job.schedule();
        } else if (tp.getName().equals(REPORT_TEMPLATE_LABEL)) {
            final ReportTemplateService reportTemplateService = (ReportTemplateService)SYNCOPE_CLIENT.getService(ReportTemplateService.class);
            final String[] templateData = new String[3];
            final String[] editorTitles = new String[]{TEMPLATE_FORMAT_CSV, TEMPLATE_FORMAT_XSL_FO, TEMPLATE_FORMAT_XSL_HTML};
            final String[] editorToolTips = new String[]{obj.getName(), obj.getName(), obj.getName()};
            Job job = new Job(LOADING_TEMPLATE_FORMAT_LABEL){

                protected IStatus run(IProgressMonitor arg0) {
                    templateData[0] = this.getStringFromTemplate(reportTemplateService, obj.getName(), ReportTemplateFormat.CSV);
                    templateData[1] = this.getStringFromTemplate(reportTemplateService, obj.getName(), ReportTemplateFormat.FO);
                    templateData[2] = this.getStringFromTemplate(reportTemplateService, obj.getName(), ReportTemplateFormat.HTML);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SyncopeView.this.getViewSite().getPage().openEditor((IEditorInput)new TemplateEditorInput(templateData, editorTitles, editorToolTips), "org.apache.syncope.ide.eclipse.plugin.editors.TemplateEditor");
                            }
                            catch (PartInitException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }

                private String getStringFromTemplate(ReportTemplateService reportTemplateService2, String name, ReportTemplateFormat format) {
                    try {
                        InputStream inpstream = (InputStream)reportTemplateService2.getFormat(name, format).getEntity();
                        Scanner sc = new Scanner(inpstream);
                        String templateContent = sc.nextLine();
                        while (sc.hasNext()) {
                            templateContent = String.valueOf(templateContent) + "\n" + sc.nextLine();
                        }
                        sc.close();
                        return templateContent;
                    }
                    catch (SyncopeClientException e) {
                        if (ClientExceptionType.NotFound.equals((Object)e.getType())) {
                            return "";
                        }
                        return null;
                    }
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    private void updateTreeViewer() {
        final Display display = Display.getDefault();
        Job job = new Job(LOADING_TEMPLATE_LABEL){

            protected IStatus run(IProgressMonitor monitor) {
                block5: {
                    try {
                        try {
                            SyncopeView.this.vcp.initialize();
                        }
                        catch (Exception e) {
                            display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Shell shell = SyncopeView.this.viewer.getControl().getShell();
                                    if (e instanceof AccessControlException) {
                                        MessageDialog.openError((Shell)shell, (String)"Incorrect Credentials", (String)("Unable to authenticate " + SyncopeView.this.vcp.username));
                                    } else if (e instanceof ProcessingException) {
                                        MessageDialog.openError((Shell)shell, (String)"Incorrect Url", (String)("Unable to find apache syncope at " + SyncopeView.this.vcp.deploymentUrl));
                                    } else if (e instanceof WebServiceException) {
                                        MessageDialog.openError((Shell)shell, (String)"Invalid Url", (String)("Not a valid url " + SyncopeView.this.vcp.username));
                                    } else {
                                        e.printStackTrace();
                                    }
                                }
                            });
                            display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    SyncopeView.this.refreshAction.setEnabled(true);
                                    SyncopeView.this.viewer.refresh();
                                }
                            });
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        display.syncExec(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    display.syncExec(new /* invalid duplicate definition of identical inner class */);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SyncopeView.this.doubleClickAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public static void setMailTemplateContent(String key, MailTemplateFormat format, String content) {
        MailTemplateService mailTemplateService = (MailTemplateService)SYNCOPE_CLIENT.getService(MailTemplateService.class);
        mailTemplateService.setFormat(key, format, (InputStream)new ByteArrayInputStream(content.getBytes()));
    }

    public static void setReportTemplateContent(String key, ReportTemplateFormat format, String content) {
        ReportTemplateService reportTemplateService = (ReportTemplateService)SYNCOPE_CLIENT.getService(ReportTemplateService.class);
        reportTemplateService.setFormat(key, format, (InputStream)new ByteArrayInputStream(content.getBytes()));
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private TreeParent invisibleRoot;
        private String deploymentUrl;
        private String username;
        private String password;

        ViewContentProvider() {
            this.deploymentUrl = "";
            this.username = "";
            this.password = "";
        }

        ViewContentProvider(String deploymentUrl, String username, String password) {
            this.deploymentUrl = deploymentUrl;
            this.username = username;
            this.password = password;
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent.equals(SyncopeView.this.getViewSite())) {
                if (this.invisibleRoot == null) {
                    this.initialize();
                }
                return this.getChildren(this.invisibleRoot);
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof TreeObject) {
                return ((TreeObject)child).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).getChildren();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).hasChildren();
            }
            return false;
        }

        public void initialize() throws AccessControlException, ProcessingException {
            this.invisibleRoot = new TreeParent("");
            if (!(this.deploymentUrl == null || this.deploymentUrl.equals("") || this.username == null || this.username.equals("") || this.password == null || this.password.equals(""))) {
                TreeParent p1 = new TreeParent(SyncopeView.MAIL_TEMPLATE_LABEL);
                TreeParent p2 = new TreeParent(SyncopeView.REPORT_TEMPLATE_LABEL);
                SYNCOPE_CLIENT = new SyncopeClientFactoryBean().setAddress(this.deploymentUrl).create(this.username, this.password);
                MailTemplateService mailTemplateService = (MailTemplateService)SYNCOPE_CLIENT.getService(MailTemplateService.class);
                List mailTemplateTOs = mailTemplateService.list();
                int i = 0;
                while (i < mailTemplateTOs.size()) {
                    TreeObject obj = new TreeObject(((MailTemplateTO)mailTemplateTOs.get(i)).getKey());
                    p1.addChild(obj);
                    ++i;
                }
                this.invisibleRoot.addChild(p1);
                ReportTemplateService reportTemplateService = (ReportTemplateService)SYNCOPE_CLIENT.getService(ReportTemplateService.class);
                List reportTemplateTOs = reportTemplateService.list();
                int i2 = 0;
                while (i2 < reportTemplateTOs.size()) {
                    TreeObject obj = new TreeObject(((ReportTemplateTO)reportTemplateTOs.get(i2)).getKey());
                    p2.addChild(obj);
                    ++i2;
                }
                this.invisibleRoot.addChild(p2);
            }
        }
    }

    class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            String imageKey = "IMG_OBJ_ELEMENTS";
            if (obj instanceof TreeParent) {
                imageKey = "IMG_OBJ_FOLDER";
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
        }
    }
}

