/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger.openapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.swagger.openapi.OpenApiConfiguration;
import org.apache.cxf.jaxrs.swagger.openapi.SwaggerToOpenApiConversionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

@Provider
@PreMatching
public final class SwaggerToOpenApiConversionFilter
implements ContainerRequestFilter,
WriterInterceptor {
    private static final String SWAGGER_PATH = "swagger.json";
    private static final String OPEN_API_PATH = "openapi.json";
    private static final String OPEN_API_PROPERTY = "openapi";
    private OpenApiConfiguration openApiConfig;
    private String openApiJsonPath = "openapi.json";

    public void filter(ContainerRequestContext reqCtx) throws IOException {
        String path = reqCtx.getUriInfo().getPath();
        if (path.endsWith(this.openApiJsonPath)) {
            reqCtx.setRequestUri(URI.create(SWAGGER_PATH));
            JAXRSUtils.getCurrentMessage().getExchange().put((Object)OPEN_API_PROPERTY, (Object)Boolean.TRUE);
        }
    }

    public OpenApiConfiguration getOpenApiConfig() {
        return this.openApiConfig;
    }

    public void setOpenApiConfig(OpenApiConfiguration openApiConfig) {
        this.openApiConfig = openApiConfig;
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        if (this.isOpenApiRequested()) {
            OutputStream os = context.getOutputStream();
            CachedOutputStream cos = new CachedOutputStream();
            context.setOutputStream((OutputStream)cos);
            context.proceed();
            String swaggerJson = IOUtils.readStringFromStream((InputStream)cos.getInputStream());
            String openApiJson = SwaggerToOpenApiConversionUtils.getOpenApiFromSwaggerJson(this.createMessageContext(), swaggerJson, this.openApiConfig);
            os.write(StringUtils.toBytesUTF8((String)openApiJson));
            os.flush();
        } else {
            context.proceed();
        }
    }

    private MessageContext createMessageContext() {
        return (MessageContext)JAXRSUtils.createContextValue((Message)JAXRSUtils.getCurrentMessage(), null, MessageContext.class);
    }

    private boolean isOpenApiRequested() {
        return Boolean.TRUE == JAXRSUtils.getCurrentMessage().getExchange().get((Object)OPEN_API_PROPERTY);
    }

    public void setOpenApiJsonPath(String openApiJsonPath) {
        this.openApiJsonPath = openApiJsonPath;
    }
}

