/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.client.console.panels.SAML2IdPsDirectoryPanel;
import org.apache.syncope.client.console.rest.SAML2IdPsRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wizards.AjaxWizardBuilder;
import org.apache.syncope.client.console.wizards.SAML2IdPMappingPanel;
import org.apache.syncope.client.console.wizards.resources.ItemTransformersTogglePanel;
import org.apache.syncope.client.console.wizards.resources.JEXLTransformersTogglePanel;
import org.apache.syncope.common.lib.to.ItemTO;
import org.apache.syncope.common.lib.to.SAML2IdPTO;
import org.apache.syncope.common.lib.types.SAML2BindingType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.ListModel;

public class SAML2IdPWizardBuilder
extends AjaxWizardBuilder<SAML2IdPTO> {
    private static final long serialVersionUID = 5952696913893950460L;
    private final SAML2IdPsRestClient restClient = new SAML2IdPsRestClient();
    private final SAML2IdPsDirectoryPanel directoryPanel;
    private final IModel<List<String>> actionsClasses = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return new ArrayList<String>(SAML2IdPWizardBuilder.this.restClient.getActionsClasses());
        }
    };

    public SAML2IdPWizardBuilder(SAML2IdPsDirectoryPanel directoryPanel, SAML2IdPTO idpTO, PageReference pageRef) {
        super((Serializable)idpTO, pageRef);
        this.directoryPanel = directoryPanel;
    }

    protected WizardModel buildModelSteps(SAML2IdPTO modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new IdP(modelObject));
        Mapping mapping = new Mapping(modelObject);
        mapping.setOutputMarkupId(true);
        ItemTransformersTogglePanel mapItemTransformers = new ItemTransformersTogglePanel((WebMarkupContainer)mapping, this.pageRef);
        this.addOuterObject(new Component[]{mapItemTransformers});
        JEXLTransformersTogglePanel jexlTransformers = new JEXLTransformersTogglePanel((WebMarkupContainer)mapping, this.pageRef);
        this.addOuterObject(new Component[]{jexlTransformers});
        mapping.add(new Component[]{new SAML2IdPMappingPanel("mapping", modelObject, mapItemTransformers, jexlTransformers)});
        wizardModel.add((IWizardStep)mapping);
        return wizardModel;
    }

    protected Serializable onApplyInternal(SAML2IdPTO modelObject) {
        long connObjectKeyCount = IterableUtils.countMatches((Iterable)modelObject.getItems(), (Predicate)new Predicate<ItemTO>(){

            public boolean evaluate(ItemTO item) {
                return item.isConnObjectKey();
            }
        });
        if (connObjectKeyCount != 1L) {
            throw new IllegalArgumentException(new StringResourceModel("connObjectKeyValidation", (Component)this.directoryPanel).getString());
        }
        this.restClient.update(modelObject);
        return modelObject;
    }

    private static final class Mapping
    extends WizardStep {
        private static final long serialVersionUID = 3454904947720856253L;

        Mapping(SAML2IdPTO item) {
            this.setTitleModel((IModel)Model.of((Serializable)((Object)"Mapping")));
            this.setSummaryModel((IModel)Model.of((Serializable)((Object)"")));
        }
    }

    private final class IdP
    extends WizardStep {
        private static final long serialVersionUID = 854012593185195024L;

        IdP(SAML2IdPTO idpTO) {
            super("", "");
            ArrayList<Object> fields = new ArrayList<Object>();
            AjaxTextFieldPanel name = new AjaxTextFieldPanel("field", "name", (IModel)new PropertyModel((Object)idpTO, "name"), false);
            name.setRequired(true);
            fields.add(name);
            AjaxCheckBoxPanel createUnmatching = new AjaxCheckBoxPanel("field", "createUnmatching", (IModel)new PropertyModel((Object)idpTO, "createUnmatching"), false);
            fields.add(createUnmatching);
            AjaxCheckBoxPanel updateMatching = new AjaxCheckBoxPanel("field", "updateMatching", (IModel)new PropertyModel((Object)idpTO, "updateMatching"), false);
            fields.add(updateMatching);
            AjaxCheckBoxPanel useDeflateEncoding = new AjaxCheckBoxPanel("field", "useDeflateEncoding", (IModel)new PropertyModel((Object)idpTO, "useDeflateEncoding"), false);
            fields.add(useDeflateEncoding);
            AjaxCheckBoxPanel supportUnsolicited = new AjaxCheckBoxPanel("field", "supportUnsolicited", (IModel)new PropertyModel((Object)idpTO, "supportUnsolicited"), false);
            fields.add(supportUnsolicited);
            AjaxDropDownChoicePanel bindingType = new AjaxDropDownChoicePanel("field", "bindingType", (IModel)new PropertyModel((Object)idpTO, "bindingType"), false);
            bindingType.setChoices(Arrays.asList(SAML2BindingType.values()));
            fields.add(bindingType);
            AjaxPalettePanel actionsClassNames = new AjaxPalettePanel.Builder().setAllowMoveAll(true).setAllowOrder(true).setName(new StringResourceModel("actionsClassNames", (Component)SAML2IdPWizardBuilder.this.directoryPanel).getString()).build("field", (IModel)new PropertyModel((Object)idpTO, "actionsClassNames"), (IModel)new ListModel((List)SAML2IdPWizardBuilder.this.actionsClasses.getObject()));
            actionsClassNames.setOutputMarkupId(true);
            fields.add(actionsClassNames);
            this.add(new Component[]{new ListView<Component>("fields", fields){
                private static final long serialVersionUID = -9180479401817023838L;

                protected void populateItem(ListItem<Component> item) {
                    item.add(new Component[]{(Component)item.getModelObject()});
                }
            }});
        }
    }
}

