/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.camel.producer;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.AnyObjectPatch;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.camel.producer.AbstractProducer;

public class UpdateProducer
extends AbstractProducer {
    public UpdateProducer(Endpoint endpoint, AnyTypeKind anyTypeKind) {
        super(endpoint, anyTypeKind);
    }

    public void process(Exchange exchange) throws Exception {
        if (exchange.getIn().getBody() instanceof WorkflowResult) {
            Object actual = exchange.getProperty("actual");
            Boolean nullPriorityAsync = (Boolean)exchange.getProperty("nullPriorityAsync", Boolean.class);
            Set excludedResources = (Set)exchange.getProperty("excludedResources", Set.class);
            if (actual instanceof UserPatch || this.isPull()) {
                List tasks;
                WorkflowResult updated = (WorkflowResult)exchange.getIn().getBody();
                if (this.isPull()) {
                    boolean passwordNotNull = ((UserPatch)((Pair)updated.getResult()).getKey()).getPassword() != null;
                    tasks = this.getPropagationManager().getUserUpdateTasks(updated, passwordNotNull, (Collection)excludedResources);
                } else {
                    tasks = this.getPropagationManager().getUserUpdateTasks(updated);
                }
                PropagationReporter propagationReporter = this.getPropagationTaskExecutor().execute((Collection)tasks, nullPriorityAsync.booleanValue());
                exchange.getOut().setBody((Object)Pair.of((Object)((Pair)updated.getResult()).getLeft(), (Object)propagationReporter.getStatuses()));
            } else if (actual instanceof AnyPatch) {
                WorkflowResult updated = (WorkflowResult)exchange.getIn().getBody();
                List tasks = this.getPropagationManager().getUpdateTasks(actual instanceof AnyObjectPatch ? AnyTypeKind.ANY_OBJECT : AnyTypeKind.GROUP, ((AnyPatch)updated.getResult()).getKey(), false, null, updated.getPropByRes(), (Collection)((AnyPatch)actual).getVirAttrs(), (Collection)excludedResources);
                PropagationReporter propagationReporter = this.getPropagationTaskExecutor().execute((Collection)tasks, nullPriorityAsync.booleanValue());
                exchange.getOut().setBody((Object)Pair.of((Object)updated.getResult(), (Object)propagationReporter.getStatuses()));
            }
        }
    }
}

