/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.camel;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.component.metrics.routepolicy.MetricsRoutePolicyFactory;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.io.IOUtils;
import org.apache.syncope.core.persistence.api.dao.CamelRouteDAO;
import org.apache.syncope.core.persistence.api.entity.CamelRoute;
import org.apache.syncope.core.provisioning.camel.CamelException;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;

@Component
public class SyncopeCamelContext {
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeCamelContext.class);
    @Autowired
    private CamelRouteDAO routeDAO;
    private SpringCamelContext camelContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpringCamelContext getContext() {
        SyncopeCamelContext syncopeCamelContext = this;
        synchronized (syncopeCamelContext) {
            if (this.camelContext == null) {
                this.camelContext = new SpringCamelContext((ApplicationContext)ApplicationContextProvider.getApplicationContext());
                this.camelContext.setStreamCaching(Boolean.valueOf(false));
                this.camelContext.setAllowUseOriginalMessage(Boolean.valueOf(false));
                this.camelContext.addRoutePolicyFactory((RoutePolicyFactory)new MetricsRoutePolicyFactory());
            }
        }
        if (this.camelContext.getRouteDefinitions().isEmpty()) {
            List routes = this.routeDAO.findAll();
            LOG.debug("{} route(s) are going to be loaded ", (Object)routes.size());
            this.loadContext(CollectionUtils.collect((Iterable)routes, (Transformer)new Transformer<CamelRoute, String>(){

                public String transform(CamelRoute input) {
                    return input.getContent();
                }
            }));
            try {
                this.camelContext.start();
            }
            catch (Exception e) {
                LOG.error("While starting Camel context", (Throwable)e);
                throw new CamelException(e);
            }
        }
        return this.camelContext;
    }

    private void loadContext(Collection<String> routes) {
        try {
            DOMImplementationRegistry reg = DOMImplementationRegistry.newInstance();
            DOMImplementationLS domImpl = (DOMImplementationLS)((Object)reg.getDOMImplementation("LS"));
            LSParser parser = domImpl.createLSParser((short)1, null);
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.apache.camel:org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer:org.apache.camel.model.rest");
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            ArrayList<Object> routeDefs = new ArrayList<Object>();
            for (String route : routes) {
                InputStream input = IOUtils.toInputStream((String)route, (Charset)StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    LSInput lsinput = domImpl.createLSInput();
                    lsinput.setByteStream(input);
                    Element routeElement = parser.parse(lsinput).getDocumentElement();
                    routeDefs.add(unmarshaller.unmarshal((Node)routeElement, RouteDefinition.class).getValue());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    input.close();
                }
            }
            this.camelContext.addRouteDefinitions(routeDefs);
        }
        catch (Exception e) {
            LOG.error("While loading Camel context {}", (Throwable)e);
            throw new CamelException(e);
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public void updateContext(String routeKey) {
        if (this.camelContext == null) {
            this.getContext();
        } else if (!this.camelContext.getRouteDefinitions().isEmpty()) {
            this.camelContext.getRouteDefinitions().remove(this.camelContext.getRouteDefinition(routeKey));
            this.loadContext(Collections.singletonList(this.routeDAO.find(routeKey).getContent()));
        }
    }

    public void restoreRoute(String routeKey, String routeContent) {
        try {
            this.camelContext.getRouteDefinitions().remove(this.camelContext.getRouteDefinition(routeKey));
            this.loadContext(Collections.singletonList(routeContent));
            this.camelContext.start();
        }
        catch (Exception e) {
            LOG.error("While restoring Camel route {}", (Object)routeKey, (Object)e);
            throw new CamelException(e);
        }
    }

    public void restartContext() {
        try {
            this.camelContext.stop();
            this.camelContext.start();
        }
        catch (Exception e) {
            LOG.error("While restarting Camel context", (Throwable)e);
            throw new CamelException(e);
        }
    }
}

