/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.ResponseHeader;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.rest.api.beans.SchemaQuery;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Api(tags={"Schemas"}, authorizations={@Authorization(value="BasicAuthentication"), @Authorization(value="Bearer")})
@Path(value="schemas")
public interface SchemaService
extends JAXRSService {
    @GET
    @Path(value="{type}")
    @Produces(value={"application/json", "application/xml"})
    public <T extends SchemaTO> List<T> search(@BeanParam SchemaQuery var1);

    @GET
    @Path(value="{type}/{key}")
    @Produces(value={"application/json", "application/xml"})
    public <T extends SchemaTO> T read(@NotNull @PathParam(value="type") SchemaType var1, @NotNull @PathParam(value="key") String var2);

    @ApiResponses(value={@ApiResponse(code=201, message="Schema successfully created", responseHeaders={@ResponseHeader(name="X-Syncope-Key", response=String.class, description="Key value for the entity created"), @ResponseHeader(name="Location", response=String.class, description="URL of the entity created")})})
    @POST
    @Path(value="{type}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response create(@NotNull @PathParam(value="type") SchemaType var1, @NotNull SchemaTO var2);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @PUT
    @Path(value="{type}/{key}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public void update(@NotNull @PathParam(value="type") SchemaType var1, @NotNull SchemaTO var2);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @DELETE
    @Path(value="{type}/{key}")
    @Produces(value={"application/json", "application/xml"})
    public void delete(@NotNull @PathParam(value="type") SchemaType var1, @NotNull @PathParam(value="key") String var2);
}

