/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.grid;

import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.grid.Grid2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.point.PointArray2D;
import math.geom2d.point.PointSet2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SquareGrid2D
implements Grid2D {
    double x0 = 0.0;
    double y0 = 0.0;
    double sx = 1.0;
    double sy = 1.0;

    public SquareGrid2D() {
    }

    public SquareGrid2D(Point2D origin) {
        this(origin.x(), origin.y(), 1.0, 1.0);
    }

    public SquareGrid2D(Point2D origin, double s) {
        this(origin.x(), origin.y(), s, s);
    }

    public SquareGrid2D(Point2D origin, double sx, double sy) {
        this(origin.x(), origin.y(), sx, sy);
    }

    public SquareGrid2D(double x0, double y0, double s) {
        this(x0, y0, s, s);
    }

    public SquareGrid2D(double s) {
        this(0.0, 0.0, s, s);
    }

    public SquareGrid2D(double sx, double sy) {
        this(0.0, 0.0, sx, sy);
    }

    public SquareGrid2D(double x0, double y0, double sx, double sy) {
        this.x0 = x0;
        this.y0 = y0;
        this.sx = sx;
        this.sy = sy;
    }

    @Deprecated
    public void setOrigin(Point2D point) {
        this.x0 = point.x();
        this.y0 = point.y();
    }

    @Override
    public Point2D getOrigin() {
        return new Point2D(this.x0, this.y0);
    }

    public double getSizeX() {
        return this.sx;
    }

    public double getSizeY() {
        return this.sy;
    }

    @Deprecated
    public void setSize(double s) {
        this.sx = s;
        this.sy = s;
    }

    @Deprecated
    public void setSize(double sx, double sy) {
        this.sx = sx;
        this.sy = sy;
    }

    @Override
    public Point2D getClosestVertex(Point2D point) {
        double nx = Math.round((point.x() - this.x0) / this.sx);
        double ny = Math.round((point.y() - this.y0) / this.sy);
        return new Point2D(nx * this.sx + this.x0, ny * this.sy + this.y0);
    }

    @Override
    public Collection<LineSegment2D> getEdges(Box2D box) {
        double xmin = box.getMinX();
        double ymin = box.getMinY();
        double xmax = box.getMaxX();
        double ymax = box.getMaxY();
        double xi = Math.ceil((xmin - this.x0) / this.sx) * this.sx + this.x0;
        double yi = Math.ceil((ymin - this.y0) / this.sy) * this.sy + this.y0;
        ArrayList<LineSegment2D> array = new ArrayList<LineSegment2D>();
        double y = yi;
        while (y - ymax < 1.0E-12) {
            array.add(new LineSegment2D(xmin, y, xmax, y));
            y += this.sy;
        }
        double x = xi;
        while (x - xmax < 1.0E-12) {
            array.add(new LineSegment2D(x, ymin, x, ymax));
            x += this.sx;
        }
        return array;
    }

    @Override
    public PointSet2D getVertices(Box2D box) {
        double xmin = box.getMinX();
        double ymin = box.getMinY();
        double xmax = box.getMaxX();
        double ymax = box.getMaxY();
        double xi = Math.ceil((xmin - this.x0) / this.sx) * this.sx + this.x0;
        double yi = Math.ceil((ymin - this.y0) / this.sy) * this.sy + this.y0;
        ArrayList<Point2D> array = new ArrayList<Point2D>();
        double y = yi;
        while (y - ymax < 1.0E-12) {
            double x = xi;
            while (x - xmax < 1.0E-12) {
                array.add(new Point2D(x, y));
                x += this.sx;
            }
            y += this.sy;
        }
        return new PointArray2D(array);
    }
}

