/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.SAML2LoginResponseTO;
import org.apache.syncope.common.lib.to.SAML2ReceivedResponseTO;
import org.apache.syncope.common.lib.to.SAML2RequestTO;
import org.apache.syncope.common.rest.api.service.SAML2SPService;
import org.apache.syncope.core.logic.SAML2SPLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SAML2SPServiceImpl
extends AbstractServiceImpl
implements SAML2SPService {
    @Autowired
    private SAML2SPLogic logic;

    public Response getMetadata(final String spEntityID, final String urlContext) {
        StreamingOutput sout = new StreamingOutput(){

            public void write(OutputStream os) throws IOException {
                SAML2SPServiceImpl.this.logic.getMetadata(StringUtils.appendIfMissing((String)spEntityID, (CharSequence)"/", (CharSequence[])new CharSequence[0]), urlContext, os);
            }
        };
        return Response.ok((Object)sout).type("application/xml").build();
    }

    public SAML2RequestTO createLoginRequest(String spEntityID, String idpEntityID) {
        return this.logic.createLoginRequest(StringUtils.appendIfMissing((String)spEntityID, (CharSequence)"/", (CharSequence[])new CharSequence[0]), idpEntityID);
    }

    public SAML2LoginResponseTO validateLoginResponse(SAML2ReceivedResponseTO reponse) {
        return this.logic.validateLoginResponse(reponse);
    }

    public SAML2RequestTO createLogoutRequest(String spEntityID) {
        return this.logic.createLogoutRequest(this.getJWTToken(), StringUtils.appendIfMissing((String)spEntityID, (CharSequence)"/", (CharSequence[])new CharSequence[0]));
    }

    public void validateLogoutResponse(SAML2ReceivedResponseTO response) {
        this.logic.validateLogoutResponse(this.getJWTToken(), response);
    }

    private String getJWTToken() {
        String[] parts;
        String auth = this.messageContext.getHttpHeaders().getHeaderString("Authorization");
        String[] stringArray = parts = auth == null ? null : auth.split(" ");
        if (parts == null || parts.length != 2 || !"Bearer".equals(parts[0])) {
            return null;
        }
        return parts[1];
    }
}

