/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.scheduler;

import com.googlecode.wicket.jquery.core.utils.DateUtils;
import com.googlecode.wicket.kendo.ui.scheduler.ISchedulerVisitor;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SchedulerEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_RANGE = 1;
    private Object id;
    private String title;
    private long start;
    private long end;
    private boolean allDay = false;
    private String description = null;
    private String recurrenceId = null;
    private String recurrenceRule = null;
    private String recurrenceException = null;
    private boolean visible = true;
    private final Map<String, Object> fields = new HashMap<String, Object>();

    SchedulerEvent() {
        this((Object)null, "", new Date());
    }

    public SchedulerEvent(Object id, String title, Date start) {
        this(id, title, start.getTime());
    }

    public SchedulerEvent(Object id, String title, long start) {
        this(id, title, start, DateUtils.addHours((long)start, (int)1));
    }

    public SchedulerEvent(Object id, String title, Date start, Date end) {
        this(id, title, start.getTime(), end.getTime());
    }

    public SchedulerEvent(Object id, String title, long start, long end) {
        this.id = id;
        this.title = title;
        this.start = start;
        this.end = end;
    }

    public SchedulerEvent(Number id, String title, Date start) {
        this(id, title, start.getTime());
    }

    public SchedulerEvent(Number id, String title, long start) {
        this(id, title, start, DateUtils.addHours((long)start, (int)1));
    }

    public SchedulerEvent(Number id, String title, Date start, Date end) {
        this(id, title, start.getTime(), end.getTime());
    }

    public SchedulerEvent(Number id, String title, long start, long end) {
        this.id = id;
        this.title = title;
        this.start = start;
        this.end = end;
    }

    public Object getId() {
        return this.id;
    }

    public <T> T getId(Class<T> type) {
        return (T)this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getStart() {
        return new Date(this.start);
    }

    public void setStart(Date date) {
        this.setStart(date.getTime());
    }

    public void setStart(long date) {
        this.start = date;
    }

    public Date getEnd() {
        return new Date(this.end);
    }

    public void setEnd(Date date) {
        this.setEnd(date.getTime());
    }

    public void setEnd(long date) {
        this.end = date;
    }

    public boolean isAllDay() {
        return this.allDay;
    }

    public void setAllDay(boolean allDay) {
        this.allDay = allDay;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String getRecurrenceId() {
        return this.recurrenceId;
    }

    public void setRecurrenceId(String id) {
        this.recurrenceId = id;
    }

    public String getRecurrenceRule() {
        return this.recurrenceRule;
    }

    public void setRecurrenceRule(String rule) {
        this.recurrenceRule = rule;
    }

    public String getRecurrenceException() {
        return this.recurrenceException;
    }

    public void setRecurrenceException(String exception) {
        this.recurrenceException = exception;
    }

    public Set<String> getFields() {
        return this.fields.keySet();
    }

    public final Object getValue(String field) {
        return this.fields.get(field);
    }

    public final Object getValue(String field, Object defaultValue) {
        Object value = this.fields.get(field);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public final void setValue(String field, Object value) {
        this.fields.put(field, value);
    }

    public final void accept(ISchedulerVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.title;
    }

    public static boolean isNew(SchedulerEvent event) {
        String id = String.valueOf(event.id);
        return id.equals("null") || id.equals("0");
    }
}

