/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.layout;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.layout.IResponsiveListener;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;

public class ResponsiveBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoResponsivePanel";
    private final IResponsiveListener listener;
    private JQueryAjaxBehavior onOpenAjaxBehavior = null;
    private JQueryAjaxBehavior onCloseAjaxBehavior = null;

    public ResponsiveBehavior(String selector, IResponsiveListener listener) {
        this(selector, new Options(), listener);
    }

    public ResponsiveBehavior(String selector, Options options, IResponsiveListener listener) {
        super(selector, METHOD, options);
        this.listener = (IResponsiveListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.listener.isOpenEventEnabled()) {
            this.onOpenAjaxBehavior = this.newOnOpenAjaxBehavior(this);
            component.add(new Behavior[]{this.onOpenAjaxBehavior});
        }
        if (this.listener.isCloseEventEnabled()) {
            this.onCloseAjaxBehavior = this.newOnCloseAjaxBehavior(this);
            component.add(new Behavior[]{this.onCloseAjaxBehavior});
        }
    }

    @Override
    public void onConfigure(Component component) {
        if (this.onOpenAjaxBehavior != null) {
            this.setOption("open", this.onOpenAjaxBehavior.getCallbackFunction());
        }
        if (this.onCloseAjaxBehavior != null) {
            this.setOption("close", this.onCloseAjaxBehavior.getCallbackFunction());
        }
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof OpenEvent) {
            this.listener.onOpen(target);
        }
        if (event instanceof CloseEvent) {
            this.listener.onClose(target);
        }
    }

    protected JQueryAjaxBehavior newOnOpenAjaxBehavior(IJQueryAjaxAware source) {
        return new OnOpenAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnCloseAjaxBehavior(IJQueryAjaxAware source) {
        return new OnCloseAjaxBehavior(source);
    }

    protected static class CloseEvent
    extends JQueryEvent {
        protected CloseEvent() {
        }
    }

    protected static class OpenEvent
    extends JQueryEvent {
        protected OpenEvent() {
        }
    }

    protected static class OnCloseAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnCloseAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e")};
        }

        protected JQueryEvent newEvent() {
            return new CloseEvent();
        }
    }

    protected static class OnOpenAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnOpenAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e")};
        }

        protected JQueryEvent newEvent() {
            return new OpenEvent();
        }
    }
}

