/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.button;

import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.kendo.ui.form.button.AjaxIndicatingButtonBehavior;
import com.googlecode.wicket.kendo.ui.form.button.Button;
import com.googlecode.wicket.kendo.ui.form.button.ButtonBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndicatingButton
extends Button {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(IndicatingButton.class);

    public IndicatingButton(String id) {
        super(id);
    }

    public IndicatingButton(String id, IModel<String> model) {
        super(id, model);
    }

    protected boolean isDisabledOnClick() {
        return false;
    }

    @Override
    public void onConfigure(JQueryBehavior behavior) {
        super.onConfigure(behavior);
        behavior.setOption("enable", (Object)this.isEnabledInHierarchy());
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (!"button".equalsIgnoreCase(tag.getName())) {
            LOG.warn("IndicatingButton should be applied on a 'button' tag");
        }
    }

    @Override
    public ButtonBehavior newWidgetBehavior(String selector) {
        return new AjaxIndicatingButtonBehavior(selector){
            private static final long serialVersionUID = 1L;

            @Override
            protected Options newOnClickOptions() {
                Options options = super.newOnClickOptions();
                if (IndicatingButton.this.isDisabledOnClick()) {
                    options.set("enable", (Object)false);
                }
                return options;
            }
        };
    }
}

