/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.util.Date;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.patch.StatusPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.service.UserService;
import org.apache.syncope.core.logic.AbstractAnyLogic;
import org.apache.syncope.core.logic.UserLogic;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.rest.cxf.service.AbstractAnyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
extends AbstractAnyService<UserTO, UserPatch>
implements UserService {
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private UserLogic logic;

    @Override
    protected AnyDAO<?> getAnyDAO() {
        return this.userDAO;
    }

    @Override
    protected AbstractAnyLogic<UserTO, UserPatch> getAnyLogic() {
        return this.logic;
    }

    @Override
    protected UserPatch newPatch(String key) {
        UserPatch patch = new UserPatch();
        patch.setKey(key);
        return patch;
    }

    public Response create(UserTO userTO, boolean storePassword) {
        ProvisioningResult created = this.logic.create(userTO, storePassword, this.isNullPriorityAsync());
        return this.createResponse(created);
    }

    public Response update(UserTO userTO) {
        userTO.setKey(this.getActualKey(userTO.getKey()));
        UserTO before = this.logic.read(userTO.getKey());
        this.checkETag(before.getETagValue());
        ProvisioningResult updated = this.logic.update(AnyOperations.diff((UserTO)userTO, (UserTO)before, (boolean)false), this.isNullPriorityAsync());
        return this.modificationResponse(updated);
    }

    public Response update(UserPatch userPatch) {
        return this.doUpdate(userPatch);
    }

    public Response status(StatusPatch statusPatch) {
        Date etagDate = this.findLastChange(statusPatch.getKey());
        this.checkETag(String.valueOf(etagDate.getTime()));
        ProvisioningResult updated = this.logic.status(statusPatch, this.isNullPriorityAsync());
        return this.modificationResponse(updated);
    }
}

