/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.apache.syncope.common.lib.to.RoleTO;
import org.apache.syncope.common.rest.api.service.RoleService;
import org.apache.syncope.core.logic.RoleLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RoleServiceImpl
extends AbstractServiceImpl
implements RoleService {
    @Autowired
    private RoleLogic logic;

    public List<RoleTO> list() {
        return this.logic.list();
    }

    public RoleTO read(String key) {
        return this.logic.read(key);
    }

    public Response create(RoleTO roleTO) {
        RoleTO created = this.logic.create(roleTO);
        URI location = this.uriInfo.getAbsolutePathBuilder().path(created.getKey()).build(new Object[0]);
        return Response.created((URI)location).header("X-Syncope-Key", (Object)created.getKey()).build();
    }

    public void update(RoleTO roleTO) {
        this.logic.update(roleTO);
    }

    public void delete(String key) {
        this.logic.delete(key);
    }

    public Response getConsoleLayoutInfo(String key) {
        final String template = this.logic.getConsoleLayoutInfo(key);
        StreamingOutput sout = new StreamingOutput(){

            public void write(OutputStream os) throws IOException {
                os.write(template.getBytes());
            }
        };
        return Response.ok((Object)sout).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public void setConsoleLayoutInfo(String key, InputStream consoleLayoutIn) {
        try {
            this.logic.setConsoleLayoutInfo(key, IOUtils.toString((InputStream)consoleLayoutIn, (String)StandardCharsets.UTF_8.name()));
        }
        catch (IOException e) {
            LOG.error("While setting console layout info for role {}", (Object)key, (Object)e);
            throw new InternalServerErrorException("Could not read entity", (Throwable)e);
        }
    }

    public void removeConsoleLayoutInfo(String key) {
        this.logic.setConsoleLayoutInfo(key, null);
    }
}

