/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.apache.syncope.common.lib.to.ReportTemplateTO;
import org.apache.syncope.common.lib.types.ReportTemplateFormat;
import org.apache.syncope.common.rest.api.service.ReportTemplateService;
import org.apache.syncope.core.logic.ReportTemplateLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportTemplateServiceImpl
extends AbstractServiceImpl
implements ReportTemplateService {
    @Autowired
    private ReportTemplateLogic logic;

    public Response create(ReportTemplateTO reportTemplateTO) {
        ReportTemplateTO created = this.logic.create(reportTemplateTO.getKey());
        URI location = this.uriInfo.getAbsolutePathBuilder().path(created.getKey()).build(new Object[0]);
        return Response.created((URI)location).header("X-Syncope-Key", (Object)created.getKey()).build();
    }

    public ReportTemplateTO read(String key) {
        return this.logic.read(key);
    }

    public List<ReportTemplateTO> list() {
        return this.logic.list();
    }

    public void delete(String key) {
        this.logic.delete(key);
    }

    public Response getFormat(String key, ReportTemplateFormat format) {
        final String template = this.logic.getFormat(key, format);
        StreamingOutput sout = new StreamingOutput(){

            public void write(OutputStream os) throws IOException {
                os.write(template.getBytes());
            }
        };
        return Response.ok((Object)sout).type("application/xml").build();
    }

    public void setFormat(String key, ReportTemplateFormat format, InputStream templateIn) {
        try {
            this.logic.setFormat(key, format, IOUtils.toString((InputStream)templateIn, (String)StandardCharsets.UTF_8.name()));
        }
        catch (IOException e) {
            LOG.error("While setting format {} for report template {}", new Object[]{format, key, e});
            throw new InternalServerErrorException("Could not read entity", (Throwable)e);
        }
    }

    public void removeFormat(String key, ReportTemplateFormat format) {
        this.logic.setFormat(key, format, null);
    }
}

