/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.AccessTokenTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.rest.api.beans.AccessTokenQuery;
import org.apache.syncope.common.rest.api.service.AccessTokenService;
import org.apache.syncope.core.logic.AccessTokenLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccessTokenServiceImpl
extends AbstractServiceImpl
implements AccessTokenService {
    @Autowired
    private AccessTokenLogic logic;

    public Response login() {
        Pair login = this.logic.login();
        return Response.noContent().header("X-Syncope-Token", login.getLeft()).header("X-Syncope-Token-Expire", (Object)DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.format((Date)login.getRight())).build();
    }

    public Response refresh() {
        Pair refresh = this.logic.refresh();
        return Response.noContent().header("X-Syncope-Token", refresh.getLeft()).header("X-Syncope-Token-Expire", (Object)DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.format((Date)refresh.getRight())).build();
    }

    public void logout() {
        this.logic.logout();
    }

    public PagedResult<AccessTokenTO> list(AccessTokenQuery query) {
        Pair result = this.logic.list(query.getPage().intValue(), query.getSize().intValue(), this.getOrderByClauses(query.getOrderBy()));
        return this.buildPagedResult((List)result.getRight(), query.getPage(), query.getSize(), (Integer)result.getLeft());
    }

    public void delete(String key) {
        this.logic.delete(key);
    }
}

