/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.resources;

import java.io.Serializable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.topology.TopologyNode;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.resources.AbstractResourceWizardBuilder;
import org.apache.syncope.client.console.wizards.resources.ResourceConnCapabilitiesPanel;
import org.apache.syncope.client.console.wizards.resources.ResourceConnConfPanel;
import org.apache.syncope.client.console.wizards.resources.ResourceDetailsPanel;
import org.apache.syncope.client.console.wizards.resources.ResourceSecurityPanel;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.markup.ComponentTag;

public class ResourceWizardBuilder
extends AbstractResourceWizardBuilder<ResourceTO> {
    private static final long serialVersionUID = 1734415311027284221L;
    private final ResourceRestClient resourceRestClient = new ResourceRestClient();
    private final ConnectorRestClient connectorRestClient = new ConnectorRestClient();
    private boolean createFlag;

    public ResourceWizardBuilder(ResourceTO resourceTO, PageReference pageRef) {
        super(resourceTO, pageRef);
    }

    @Override
    public AjaxWizard<Serializable> build(String id, AjaxWizard.Mode mode) {
        this.createFlag = mode == AjaxWizard.Mode.CREATE;
        return super.build(id, mode);
    }

    @Override
    protected WizardModel buildModelSteps(Serializable modelObject, WizardModel wizardModel) {
        ResourceTO resourceTO = (ResourceTO)ResourceTO.class.cast(modelObject);
        wizardModel.add((IWizardStep)new ResourceDetailsPanel(resourceTO, this.createFlag));
        wizardModel.add((IWizardStep)new ResourceConnConfPanel(resourceTO, this.createFlag){
            private static final long serialVersionUID = -1128269449868933504L;

            @Override
            protected Pair<Boolean, String> check(AjaxRequestTarget target) {
                return ResourceWizardBuilder.this.resourceRestClient.check((ResourceTO)this.modelObject);
            }

            protected void onComponentTag(ComponentTag tag) {
                tag.append("class", (CharSequence)"scrollable-tab-content", " ");
            }
        });
        wizardModel.add((IWizardStep)new ResourceConnCapabilitiesPanel(resourceTO, this.connectorRestClient.read(resourceTO.getConnector()).getCapabilities()));
        wizardModel.add((IWizardStep)new ResourceSecurityPanel(resourceTO));
        return wizardModel;
    }

    protected ResourceTO onApplyInternal(Serializable modelObject) {
        ResourceTO resourceTO = (ResourceTO)ResourceTO.class.cast(modelObject);
        if (this.createFlag) {
            resourceTO = this.resourceRestClient.create(resourceTO);
        } else {
            this.resourceRestClient.update(resourceTO);
        }
        return resourceTO;
    }

    @Override
    protected Serializable getCreateCustomPayloadEvent(Serializable afterObject, AjaxRequestTarget target) {
        ResourceTO actual = (ResourceTO)ResourceTO.class.cast(afterObject);
        return new AbstractResourceWizardBuilder.CreateEvent(actual.getKey(), actual.getKey(), TopologyNode.Kind.RESOURCE, (Serializable)((Object)actual.getConnector()), target);
    }
}

