/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.commons.SerializableTransformer;
import org.apache.syncope.client.console.commons.status.ConnObjectWrapper;
import org.apache.syncope.client.console.commons.status.Status;
import org.apache.syncope.client.console.commons.status.StatusBean;
import org.apache.syncope.client.console.commons.status.StatusUtils;
import org.apache.syncope.client.console.panels.ListViewPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.panels.RemoteObjectPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wizards.any.ConnObjectPanel;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusPanel
extends Panel {
    private static final long serialVersionUID = -4013796607157549641L;
    private static final Logger LOG = LoggerFactory.getLogger(StatusPanel.class);
    private Map<String, StatusBean> initialStatusBeanMap;
    private final StatusUtils statusUtils = new StatusUtils();
    private ListViewPanel<?> listViewPanel;

    public <T extends AnyTO> StatusPanel(String id, T any, IModel<List<StatusBean>> model, PageReference pageRef) {
        super(id);
        this.init(any, model, (List)CollectionUtils.collect(this.statusUtils.getConnectorObjects(any), (Transformer)new SerializableTransformer<ConnObjectWrapper, Pair<ConnObjectTO, ConnObjectWrapper>>(){
            private static final long serialVersionUID = 2658691884036294287L;

            public Pair<ConnObjectTO, ConnObjectWrapper> transform(ConnObjectWrapper input) {
                return Pair.of(null, (Object)input);
            }
        }, new ArrayList()), pageRef, false);
    }

    public <T extends AnyTO> StatusPanel(String id, T any, IModel<List<StatusBean>> model, List<Pair<ConnObjectTO, ConnObjectWrapper>> connObjects, PageReference pageRef) {
        super(id);
        this.init(any, model, connObjects, pageRef, true);
    }

    private void init(AnyTO any, IModel<List<StatusBean>> model, final List<Pair<ConnObjectTO, ConnObjectWrapper>> connObjects, PageReference pageRef, boolean enableConnObjectLink) {
        ArrayList<StatusBean> statusBeans = new ArrayList<StatusBean>(connObjects.size() + 1);
        this.initialStatusBeanMap = new LinkedHashMap<String, StatusBean>(connObjects.size() + 1);
        StatusBean syncope = new StatusBean(any, "syncope");
        if (any instanceof UserTO) {
            syncope.setConnObjectLink(((UserTO)any).getUsername());
            Object syncopeStatus = Status.UNDEFINED;
            if (((UserTO)any).getStatus() != null) {
                try {
                    syncopeStatus = Status.valueOf(((UserTO)any).getStatus().toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOG.warn("Unexpected status found: {}", (Object)((UserTO)any).getStatus(), (Object)illegalArgumentException);
                }
            }
            syncope.setStatus((Status)((Object)syncopeStatus));
        } else if (any instanceof GroupTO) {
            syncope.setConnObjectLink(((GroupTO)any).getName());
            syncope.setStatus(Status.ACTIVE);
        }
        statusBeans.add(syncope);
        this.initialStatusBeanMap.put(syncope.getResource(), syncope);
        for (Pair pair : connObjects) {
            ConnObjectWrapper entry = (ConnObjectWrapper)pair.getRight();
            StatusBean statusBean = this.statusUtils.getStatusBean(entry.getAny(), entry.getResourceName(), entry.getConnObjectTO(), any instanceof GroupTO);
            this.initialStatusBeanMap.put(entry.getResourceName(), statusBean);
            statusBeans.add(statusBean);
        }
        final MultilevelPanel mlp = new MultilevelPanel("resources");
        this.add(new Component[]{mlp});
        ListViewPanel.Builder<StatusBean> builder = new ListViewPanel.Builder<StatusBean>(StatusBean.class, pageRef){
            private static final long serialVersionUID = -6809736686861678498L;

            @Override
            protected Component getValueComponent(String key, StatusBean bean) {
                if ("status".equalsIgnoreCase(key)) {
                    return StatusUtils.getStatusImagePanel("field", bean.getStatus());
                }
                return super.getValueComponent(key, bean);
            }
        };
        builder.setModel(model);
        builder.setItems(statusBeans);
        builder.includes("resource", "connObjectLink", "status");
        builder.withChecks(ListViewPanel.CheckAvailability.NONE);
        builder.setReuseItem(false);
        ActionLink<StatusBean> connObjectLink = new ActionLink<StatusBean>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            protected boolean statusCondition(StatusBean bean) {
                Pair<ConnObjectTO, ConnObjectTO> pair = StatusPanel.this.getConnObjectTO(bean.getKey(), bean.getResource(), connObjects);
                return pair != null && pair.getRight() != null;
            }

            @Override
            public void onClick(AjaxRequestTarget target, StatusBean bean) {
                mlp.next(bean.getResource(), new RemoteAnyPanel(bean, connObjects), target);
            }
        };
        if (!enableConnObjectLink) {
            connObjectLink.disable();
        }
        builder.addAction(connObjectLink, ActionLink.ActionType.VIEW, "RESOURCE_GET_CONNOBJECT");
        this.listViewPanel = (ListViewPanel)((Object)ListViewPanel.class.cast((Object)builder.build("first")));
        mlp.setFirstLevel(this.listViewPanel);
    }

    public void setCheckAvailability(ListViewPanel.CheckAvailability check) {
        this.listViewPanel.setCheckAvailability(check);
    }

    public Map<String, StatusBean> getInitialStatusBeanMap() {
        return this.initialStatusBeanMap;
    }

    protected Pair<ConnObjectTO, ConnObjectTO> getConnObjectTO(String anyKey, String resourceName, List<Pair<ConnObjectTO, ConnObjectWrapper>> objects) {
        for (Pair<ConnObjectTO, ConnObjectWrapper> object : objects) {
            if (!anyKey.equals(((ConnObjectWrapper)object.getRight()).getAny().getKey()) || !resourceName.equalsIgnoreCase(((ConnObjectWrapper)object.getRight()).getResourceName())) continue;
            return Pair.of((Object)object.getLeft(), (Object)((ConnObjectWrapper)object.getRight()).getConnObjectTO());
        }
        return null;
    }

    public class RemoteAnyPanel
    extends RemoteObjectPanel {
        private static final long serialVersionUID = 4303365227411467563L;
        private final StatusBean bean;
        private final List<Pair<ConnObjectTO, ConnObjectWrapper>> connObjects;

        public RemoteAnyPanel(StatusBean bean, List<Pair<ConnObjectTO, ConnObjectWrapper>> connObjects) {
            this.bean = bean;
            this.connObjects = connObjects;
            this.add(new Component[]{new ConnObjectPanel("remoteObject", this.getConnObjectTO(), false)});
        }

        @Override
        protected final Pair<ConnObjectTO, ConnObjectTO> getConnObjectTO() {
            return StatusPanel.this.getConnObjectTO(this.bean.getKey(), this.bean.getResource(), this.connObjects);
        }
    }
}

