/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.markup.html.form;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFieldPanel<T>
extends Panel {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractFieldPanel.class);
    private static final long serialVersionUID = 5958017546318855690L;
    private static final String LABEL = "field-label";
    protected boolean isRequiredLabelAdded = false;
    protected String name;

    public AbstractFieldPanel(String id, String name, IModel<T> model) {
        super(id, model);
        this.name = name;
        this.add(new Component[]{new Fragment("required", "emptyFragment", (MarkupContainer)this)});
        this.add(new Component[]{new Fragment("externalAction", "emptyFragment", (MarkupContainer)this)});
        this.addLabel();
        this.setOutputMarkupId(true);
    }

    public final AbstractFieldPanel<T> addLabel() {
        return this.addLabel(this.name);
    }

    public final AbstractFieldPanel<T> addLabel(String name) {
        this.addOrReplace(new Component[]{new Label(LABEL, (IModel)new ResourceModel(name, name))});
        return this;
    }

    public AbstractFieldPanel<T> hideLabel() {
        Component label = this.get(LABEL);
        if (label != null) {
            label.setVisible(false);
        }
        return this;
    }

    public AbstractFieldPanel<T> showExternAction(Component component) {
        Fragment fragment = new Fragment("externalAction", "externalActionFragment", (MarkupContainer)this);
        this.addOrReplace(new Component[]{fragment});
        fragment.add(new Component[]{component.setRenderBodyOnly(false)});
        return this;
    }

    public boolean isRequired() {
        return false;
    }

    public AbstractFieldPanel<T> setRequired(boolean required) {
        return this;
    }

    public AbstractFieldPanel<T> addRequiredLabel() {
        if (!this.isRequired()) {
            this.setRequired(true);
        }
        Fragment fragment = new Fragment("required", "requiredFragment", (MarkupContainer)this);
        fragment.add(new Component[]{new Label("requiredLabel", (Serializable)((Object)"*"))});
        this.replace((Component)fragment);
        this.isRequiredLabelAdded = true;
        return this;
    }

    public AbstractFieldPanel<T> removeRequiredLabel() {
        if (this.isRequired()) {
            this.setRequired(false);
        }
        Fragment fragment = new Fragment("required", "emptyFragment", (MarkupContainer)this);
        this.replace((Component)fragment);
        this.isRequiredLabelAdded = false;
        return this;
    }

    protected String externalActionIcon() {
        return "";
    }

    public abstract AbstractFieldPanel<T> setModelObject(T var1);
}

