/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.tasks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.TaskRestClient;
import org.apache.syncope.client.console.tasks.SchedTaskDirectoryPanel;
import org.apache.syncope.client.console.wicket.ajax.IndicatorAjaxTimerBehavior;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.BooleanPropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.widgets.JobActionPanel;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.ProvisioningTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.util.time.Duration;

public abstract class ProvisioningTaskDirectoryPanel<T extends ProvisioningTaskTO>
extends SchedTaskDirectoryPanel<T> {
    private static final long serialVersionUID = 4984337552918213290L;
    private final String resource;

    protected ProvisioningTaskDirectoryPanel(BaseModal<?> baseModal, MultilevelPanel multiLevelPanelRef, TaskType taskType, Class<T> reference, String resource, PageReference pageRef) {
        super(baseModal, multiLevelPanelRef, taskType, reference, pageRef);
        this.resource = resource;
        ((ProvisioningTaskTO)this.schedTaskTO).setResource(resource);
        super.initResultTable();
        this.container.add(new Behavior[]{new IndicatorAjaxTimerBehavior(Duration.seconds((int)10)){
            private static final long serialVersionUID = -4661303265651934868L;

            protected void onTimer(AjaxRequestTarget target) {
                ProvisioningTaskDirectoryPanel.this.container.modelChanged();
                target.add(new Component[]{ProvisioningTaskDirectoryPanel.this.container});
            }
        }});
    }

    @Override
    protected void initResultTable() {
    }

    @Override
    protected List<IColumn<T, String>> getFieldColumns() {
        ArrayList<IColumn<T, String>> columns = new ArrayList<IColumn<T, String>>();
        columns.add((IColumn<T, String>)new KeyPropertyColumn((IModel<String>)new StringResourceModel("key", (Component)this), "key"));
        columns.add((IColumn<T, String>)new PropertyColumn((IModel)new StringResourceModel("name", (Component)this), (Object)"name", "name"));
        columns.add((IColumn<T, String>)new PropertyColumn((IModel)new StringResourceModel("description", (Component)this), (Object)"description", "description"));
        if (this.reference == PullTaskTO.class) {
            columns.add((IColumn<T, String>)new PropertyColumn((IModel)new StringResourceModel("destinationRealm", (Component)this), (Object)"destinationRealm", "destinationRealm"));
        } else if (this.reference == PushTaskTO.class) {
            columns.add((IColumn<T, String>)new PropertyColumn((IModel)new StringResourceModel("sourceRealm", (Component)this), (Object)"sourceRealm", "sourceRealm"));
        }
        columns.add((IColumn<T, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("lastExec", (Component)this), "lastExec", "lastExec"));
        columns.add((IColumn<T, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("nextExec", (Component)this), "nextExec", "nextExec"));
        columns.add((IColumn<T, String>)new PropertyColumn((IModel)new StringResourceModel("latestExecStatus", (Component)this), (Object)"latestExecStatus", "latestExecStatus"));
        columns.add((IColumn<T, String>)new BooleanPropertyColumn((IModel<String>)new StringResourceModel("active", (Component)this), "active", "active"));
        columns.add((IColumn<T, String>)new AbstractColumn<T, String>((IModel)new Model((Serializable)((Object)"")), "running"){
            private static final long serialVersionUID = -4008579357070833846L;

            public void populateItem(Item<ICellPopulator<T>> cellItem, String componentId, IModel<T> rowModel) {
                JobTO jobTO = ((TaskRestClient)ProvisioningTaskDirectoryPanel.this.restClient).getJob(((ProvisioningTaskTO)rowModel.getObject()).getKey());
                JobActionPanel panel = new JobActionPanel(componentId, jobTO, false, (Component)ProvisioningTaskDirectoryPanel.this, ProvisioningTaskDirectoryPanel.this.pageRef);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)WebPage.ENABLE, (String)String.format("%s,%s", "TASK_EXECUTE", "TASK_UPDATE"));
                cellItem.add(new Component[]{panel});
            }

            public String getCssClass() {
                return "col-xs-1";
            }
        });
        return columns;
    }

    @Override
    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof JobActionPanel.JobActionPayload) {
            this.container.modelChanged();
            ((JobActionPanel.JobActionPayload)JobActionPanel.JobActionPayload.class.cast(event.getPayload())).getTarget().add(new Component[]{this.container});
        } else {
            super.onEvent(event);
        }
    }

    protected class ProvisioningTasksProvider<T extends ProvisioningTaskTO>
    extends SchedTaskDirectoryPanel.SchedTasksProvider<T> {
        private static final long serialVersionUID = 4725679400450513556L;
        private final Class<T> reference;

        public ProvisioningTasksProvider(Class<T> reference, TaskType id, int paginatorRows) {
            super(reference, id, paginatorRows);
            this.reference = reference;
        }

        @Override
        public long size() {
            return ((TaskRestClient)ProvisioningTaskDirectoryPanel.this.restClient).count(ProvisioningTaskDirectoryPanel.this.resource, this.taskType);
        }

        @Override
        public Iterator<T> iterator(long first, long count) {
            int page = (int)first / this.paginatorRows;
            List<T> tasks = ((TaskRestClient)ProvisioningTaskDirectoryPanel.this.restClient).list(ProvisioningTaskDirectoryPanel.this.resource, this.reference, (page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort());
            Collections.sort(tasks, this.getComparator());
            return tasks.iterator();
        }
    }
}

