/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.status;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.ResourceStatusDataProvider;
import org.apache.syncope.client.console.commons.status.StatusBean;
import org.apache.syncope.client.console.commons.status.StatusUtils;
import org.apache.syncope.client.console.panels.AjaxDataTablePanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.client.console.rest.AnyObjectRestClient;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public class ResourceStatusDirectoryPanel
extends DirectoryPanel<StatusBean, StatusBean, DirectoryDataProvider<StatusBean>, AbstractAnyRestClient<?>>
implements ModalPanel {
    private static final long serialVersionUID = -9148734710505211261L;
    private final BaseModal<?> baseModal;
    private final MultilevelPanel multiLevelPanelRef;
    private String type;
    private final ResourceTO resourceTO;

    public ResourceStatusDirectoryPanel(BaseModal<?> baseModal, MultilevelPanel multiLevelPanelRef, PageReference pageRef, String type, ResourceTO resourceTO) {
        super("first", pageRef);
        this.baseModal = baseModal;
        this.multiLevelPanelRef = multiLevelPanelRef;
        this.type = type;
        this.resourceTO = resourceTO;
        this.itemKeyFieldName = "key";
        this.initResultTable();
    }

    @Override
    protected void resultTableCustomChanges(AjaxDataTablePanel.Builder<StatusBean, String> resultTableBuilder) {
        resultTableBuilder.setMultiLevelPanel(this.baseModal, this.multiLevelPanelRef);
    }

    @Override
    protected List<IColumn<StatusBean, String>> getColumns() {
        ArrayList<IColumn<StatusBean, String>> columns = new ArrayList<IColumn<StatusBean, String>>();
        columns.add((IColumn<StatusBean, String>)new PropertyColumn((IModel)new StringResourceModel("key", (Component)this), (Object)"key", "key"));
        columns.add((IColumn<StatusBean, String>)new PropertyColumn((IModel)new StringResourceModel("connObjectLink", (Component)this), (Object)"connObjectLink", "connObjectLink"));
        columns.add((IColumn<StatusBean, String>)new AbstractColumn<StatusBean, String>((IModel)new StringResourceModel("status", (Component)this)){
            private static final long serialVersionUID = -3503023501954863131L;

            public void populateItem(Item<ICellPopulator<StatusBean>> cellItem, String componentId, IModel<StatusBean> model) {
                if (((StatusBean)model.getObject()).isLinked()) {
                    cellItem.add(new Component[]{StatusUtils.getStatusImage(componentId, ((StatusBean)model.getObject()).getStatus())});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)""))});
                }
            }
        });
        return columns;
    }

    public void updateResultTable(String type, AjaxRequestTarget target) {
        this.type = type;
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{type})) {
            switch (type) {
                case "USER": {
                    this.restClient = new UserRestClient();
                    break;
                }
                case "GROUP": {
                    this.restClient = new GroupRestClient();
                    break;
                }
                default: {
                    this.restClient = new AnyObjectRestClient();
                }
            }
        }
        super.updateResultTable(target);
    }

    @Override
    protected Collection<ActionLink.ActionType> getBulkActions() {
        ArrayList<ActionLink.ActionType> bulkActions = new ArrayList<ActionLink.ActionType>();
        bulkActions.add(ActionLink.ActionType.UNLINK);
        bulkActions.add(ActionLink.ActionType.DEPROVISION);
        bulkActions.add(ActionLink.ActionType.UNASSIGN);
        return bulkActions;
    }

    @Override
    protected ResourceStatusDataProvider dataProvider() {
        return new ResourceStatusDataProvider(this.type, this.resourceTO.getKey(), this.rows, "/");
    }

    @Override
    protected String paginatorRowsKey() {
        return "";
    }
}

