/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.status;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.status.AbstractStatusBeanProvider;
import org.apache.syncope.client.console.commons.status.ConnObjectWrapper;
import org.apache.syncope.client.console.commons.status.Status;
import org.apache.syncope.client.console.commons.status.StatusBean;
import org.apache.syncope.client.console.commons.status.StatusUtils;
import org.apache.syncope.client.console.panels.AjaxDataTablePanel;
import org.apache.syncope.client.console.panels.ConnObjectDetails;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.client.console.rest.AnyObjectRestClient;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public class AnyStatusDirectoryPanel
extends DirectoryPanel<StatusBean, StatusBean, DirectoryDataProvider<StatusBean>, AbstractAnyRestClient<?>>
implements ModalPanel {
    private static final long serialVersionUID = -9148734710505211261L;
    private final BaseModal<?> baseModal;
    private final MultilevelPanel multiLevelPanelRef;
    private final AnyTO anyTO;
    private final boolean statusOnly;
    private final ResourceRestClient resourceRestClient = new ResourceRestClient();

    public AnyStatusDirectoryPanel(BaseModal<?> baseModal, MultilevelPanel multiLevelPanelRef, PageReference pageRef, AnyTO anyTO, String itemKeyFieldName, boolean statusOnly) {
        super("first", pageRef);
        this.baseModal = baseModal;
        this.multiLevelPanelRef = multiLevelPanelRef;
        this.statusOnly = statusOnly;
        this.anyTO = anyTO;
        this.itemKeyFieldName = itemKeyFieldName;
        this.restClient = anyTO instanceof UserTO ? new UserRestClient() : (anyTO instanceof GroupTO ? new GroupRestClient() : new AnyObjectRestClient());
        this.initResultTable();
    }

    @Override
    protected void resultTableCustomChanges(AjaxDataTablePanel.Builder<StatusBean, String> resultTableBuilder) {
        resultTableBuilder.setMultiLevelPanel(this.baseModal, this.multiLevelPanelRef);
    }

    @Override
    protected List<IColumn<StatusBean, String>> getColumns() {
        ArrayList<IColumn<StatusBean, String>> columns = new ArrayList<IColumn<StatusBean, String>>();
        columns.add((IColumn<StatusBean, String>)new AbstractColumn<StatusBean, String>((IModel)new StringResourceModel("resource", (Component)this), "resource"){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<StatusBean>> cellItem, String componentId, final IModel<StatusBean> model) {
                cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)((StatusBean)model.getObject()).getResource())){
                    private static final long serialVersionUID = 8432079838783825801L;

                    protected void onComponentTag(ComponentTag tag) {
                        if (((StatusBean)model.getObject()).isLinked()) {
                            super.onComponentTag(tag);
                        } else {
                            tag.put("style", (CharSequence)"font-style: italic");
                        }
                    }
                }});
            }
        });
        columns.add((IColumn<StatusBean, String>)new PropertyColumn((IModel)new StringResourceModel("connObjectLink", (Component)this), (Object)"connObjectLink", "connObjectLink"));
        columns.add((IColumn<StatusBean, String>)new AbstractColumn<StatusBean, String>((IModel)new StringResourceModel("status", (Component)this)){
            private static final long serialVersionUID = -3503023501954863131L;

            public void populateItem(Item<ICellPopulator<StatusBean>> cellItem, String componentId, IModel<StatusBean> model) {
                if (((StatusBean)model.getObject()).isLinked()) {
                    cellItem.add(new Component[]{StatusUtils.getStatusImage(componentId, ((StatusBean)model.getObject()).getStatus())});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)""))});
                }
            }
        });
        return columns;
    }

    @Override
    public ActionsPanel<StatusBean> getActions(IModel<StatusBean> model) {
        ActionsPanel<StatusBean> panel = super.getActions(model);
        panel.add(new ActionLink<StatusBean>(){
            private static final long serialVersionUID = -7978723352517770645L;

            @Override
            protected boolean statusCondition(StatusBean bean) {
                return bean != null && bean.getConnObjectLink() != null && !bean.getResource().equalsIgnoreCase("syncope");
            }

            @Override
            public void onClick(AjaxRequestTarget target, StatusBean bean) {
                AnyStatusDirectoryPanel.this.multiLevelPanelRef.next(bean.getResource(), new ConnObjectDetails(AnyStatusDirectoryPanel.this.resourceRestClient.readConnObject(bean.getResource(), AnyStatusDirectoryPanel.this.anyTO.getType(), AnyStatusDirectoryPanel.this.anyTO.getKey())), target);
                target.add(new Component[]{AnyStatusDirectoryPanel.this.multiLevelPanelRef});
                AnyStatusDirectoryPanel.this.getTogglePanel().close(target);
            }
        }, ActionLink.ActionType.VIEW, "RESOURCE_GET_CONNOBJECT");
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBulkActions() {
        ArrayList<ActionLink.ActionType> bulkActions = new ArrayList<ActionLink.ActionType>();
        if (this.statusOnly) {
            bulkActions.add(ActionLink.ActionType.SUSPEND);
            bulkActions.add(ActionLink.ActionType.REACTIVATE);
        } else {
            bulkActions.add(ActionLink.ActionType.UNLINK);
            bulkActions.add(ActionLink.ActionType.LINK);
            bulkActions.add(ActionLink.ActionType.DEPROVISION);
            bulkActions.add(ActionLink.ActionType.PROVISION);
            bulkActions.add(ActionLink.ActionType.ASSIGN);
            bulkActions.add(ActionLink.ActionType.UNASSIGN);
        }
        return bulkActions;
    }

    @Override
    protected AttributableStatusProvider dataProvider() {
        return new AttributableStatusProvider();
    }

    @Override
    protected String paginatorRowsKey() {
        return "";
    }

    public class AttributableStatusProvider
    extends AbstractStatusBeanProvider {
        private static final long serialVersionUID = 4586969457669796621L;
        private final StatusUtils statusUtils;

        AttributableStatusProvider() {
            super(AnyStatusDirectoryPanel.this.statusOnly ? "resource" : "connObjectLink");
            this.statusUtils = new StatusUtils();
        }

        @Override
        public List<StatusBean> getStatusBeans() {
            StatusBean statusBean;
            Object actual = ((AbstractAnyRestClient)AnyStatusDirectoryPanel.this.restClient).read(AnyStatusDirectoryPanel.this.anyTO.getKey());
            ArrayList<String> resources = new ArrayList<String>();
            for (ResourceTO resourceTO : new ResourceRestClient().list()) {
                resources.add(resourceTO.getKey());
            }
            List<ConnObjectWrapper> connObjects = this.statusUtils.getConnectorObjects((AnyTO)actual);
            ArrayList<StatusBean> statusBeans = new ArrayList<StatusBean>(connObjects.size() + 1);
            for (ConnObjectWrapper entry : connObjects) {
                statusBean = this.statusUtils.getStatusBean((AnyTO)actual, entry.getResourceName(), entry.getConnObjectTO(), actual instanceof GroupTO);
                statusBeans.add(statusBean);
                resources.remove(entry.getResourceName());
            }
            if (AnyStatusDirectoryPanel.this.statusOnly) {
                StatusBean syncope = new StatusBean((AnyTO)actual, "Syncope");
                syncope.setConnObjectLink(((UserTO)actual).getUsername());
                Status syncopeStatus = Status.UNDEFINED;
                if (((UserTO)actual).getStatus() != null) {
                    try {
                        syncopeStatus = Status.valueOf(((UserTO)actual).getStatus().toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn("Unexpected status found: {}", (Object)((UserTO)actual).getStatus(), (Object)e);
                    }
                }
                syncope.setStatus(syncopeStatus);
                statusBeans.add(syncope);
            } else {
                for (String resource : resources) {
                    statusBean = this.statusUtils.getStatusBean((AnyTO)actual, resource, null, actual instanceof GroupTO);
                    statusBean.setLinked(false);
                    statusBeans.add(statusBean);
                }
            }
            return statusBeans;
        }
    }
}

