/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.common.lib.patch.ResourceDeassociationPatch;
import org.apache.syncope.common.lib.to.BulkActionResult;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.PagedConnObjectTOResult;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.ResourceDeassociationAction;
import org.apache.syncope.common.rest.api.beans.ConnObjectTOListQuery;
import org.apache.syncope.common.rest.api.service.ResourceService;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;

public class ResourceRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -6898907679835668987L;

    public Pair<Boolean, String> check(ResourceTO resourceTO) {
        boolean check = false;
        String errorMessage = null;
        try {
            ResourceRestClient.getService(ResourceService.class).check(resourceTO);
            check = true;
        }
        catch (Exception e) {
            LOG.error("Connector not found {}", (Object)resourceTO.getConnector(), (Object)e);
            errorMessage = e.getMessage();
        }
        return Pair.of((Object)check, (Object)errorMessage);
    }

    public ConnObjectTO readConnObject(String resource, String anyTypeKey, String anyKey) {
        return ResourceRestClient.getService(ResourceService.class).readConnObject(resource, anyTypeKey, anyKey);
    }

    public Pair<String, List<ConnObjectTO>> listConnObjects(String resource, String anyTypeKey, int size, String pagedResultCookie, SortParam<String> sort) {
        ConnObjectTOListQuery.Builder builder = new ConnObjectTOListQuery.Builder().pagedResultsCookie(pagedResultCookie).size(Integer.valueOf(size)).orderBy(ResourceRestClient.toOrderBy(sort));
        ArrayList result = new ArrayList();
        String nextPageResultCookie = null;
        try {
            PagedConnObjectTOResult list = ResourceRestClient.getService(ResourceService.class).listConnObjects(resource, anyTypeKey, builder.build());
            result.addAll(list.getResult());
            nextPageResultCookie = list.getPagedResultsCookie();
        }
        catch (Exception e) {
            LOG.error("While listing objects on {} for any type {}", new Object[]{resource, anyTypeKey, e});
        }
        return Pair.of((Object)nextPageResultCookie, result);
    }

    public ResourceTO read(String name) {
        return ResourceRestClient.getService(ResourceService.class).read(name);
    }

    public List<ResourceTO> list() {
        List resources = Collections.emptyList();
        try {
            resources = ResourceRestClient.getService(ResourceService.class).list();
            Collections.sort(resources, new Comparator<ResourceTO>(){

                @Override
                public int compare(ResourceTO o1, ResourceTO o2) {
                    return ComparatorUtils.naturalComparator().compare(o1.getKey(), o2.getKey());
                }
            });
        }
        catch (Exception e) {
            LOG.error("Could not fetch the Resource list", (Throwable)e);
        }
        return resources;
    }

    public ResourceTO create(ResourceTO resourceTO) {
        ResourceService service = ResourceRestClient.getService(ResourceService.class);
        Response response = service.create(resourceTO);
        return ResourceRestClient.getObject(service, response.getLocation(), ResourceTO.class);
    }

    public void update(ResourceTO resourceTO) {
        ResourceRestClient.getService(ResourceService.class).update(resourceTO);
    }

    public void delete(String name) {
        ResourceRestClient.getService(ResourceService.class).delete(name);
    }

    public BulkActionResult bulkAssociationAction(String resourceName, String anyTypeName, ResourceDeassociationAction action, List<String> anyKeys) {
        ResourceDeassociationPatch patch = new ResourceDeassociationPatch();
        patch.setKey(resourceName);
        patch.setAnyTypeKey(anyTypeName);
        patch.setAction(action);
        patch.getAnyKyes().addAll(anyKeys);
        return ResourceRestClient.getService(ResourceService.class).bulkDeassociation(patch);
    }

    public void setLatestSyncToken(String key, String anyType) {
        ResourceRestClient.getService(ResourceService.class).setLatestSyncToken(key, anyType);
    }

    public void removeSyncToken(String key, String anyType) {
        ResourceRestClient.getService(ResourceService.class).removeSyncToken(key, anyType);
    }
}

