/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.rest.api.service.AnyTypeService;

public class AnyTypeRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -2211371717449597247L;

    public AnyTypeTO read(String key) {
        AnyTypeTO type = null;
        try {
            type = AnyTypeRestClient.getService(AnyTypeService.class).read(key);
        }
        catch (SyncopeClientException e) {
            LOG.error("While reading all any types", (Throwable)e);
        }
        return type;
    }

    public List<AnyTypeTO> listAnyTypes() {
        List types = Collections.emptyList();
        try {
            types = AnyTypeRestClient.getService(AnyTypeService.class).list();
            Collections.sort(types, new AnyTypeComparator());
        }
        catch (SyncopeClientException e) {
            LOG.error("While reading all any types", (Throwable)e);
        }
        return types;
    }

    public List<String> list() {
        List types = AnyTypeRestClient.getSyncopeService().platform().getAnyTypes();
        Collections.sort(types, new AnyTypeKeyComparator());
        return types;
    }

    public void create(AnyTypeTO anyTypeTO) {
        AnyTypeRestClient.getService(AnyTypeService.class).create(anyTypeTO);
    }

    public void update(AnyTypeTO anyTypeTO) {
        AnyTypeRestClient.getService(AnyTypeService.class).update(anyTypeTO);
    }

    public void delete(String key) {
        AnyTypeRestClient.getService(AnyTypeService.class).delete(key);
    }

    public static class AnyTypeKeyComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = -7778622183107320760L;

        @Override
        public int compare(String o1, String o2) {
            if ("REALM".equals(o1)) {
                return -1;
            }
            if ("REALM".equals(o2)) {
                return 1;
            }
            if (AnyTypeKind.USER.name().equals(o1)) {
                return -1;
            }
            if (AnyTypeKind.USER.name().equals(o2)) {
                return 1;
            }
            if (AnyTypeKind.GROUP.name().equals(o1)) {
                return -1;
            }
            if (AnyTypeKind.GROUP.name().equals(2)) {
                return 1;
            }
            return ComparatorUtils.naturalComparator().compare(o1, o2);
        }
    }

    public static class AnyTypeComparator
    implements Comparator<AnyTypeTO>,
    Serializable {
        private static final long serialVersionUID = -8227715253094467138L;

        @Override
        public int compare(AnyTypeTO o1, AnyTypeTO o2) {
            if (o1.getKind() == AnyTypeKind.USER) {
                return -1;
            }
            if (o2.getKind() == AnyTypeKind.USER) {
                return 1;
            }
            if (o1.getKind() == AnyTypeKind.GROUP) {
                return -1;
            }
            if (o2.getKind() == AnyTypeKind.GROUP) {
                return 1;
            }
            return ComparatorUtils.naturalComparator().compare(o1.getKey(), o2.getKey());
        }
    }
}

