/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.reports;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.reports.ReportletWizardBuilder;
import org.apache.syncope.client.console.rest.ReportRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.report.AbstractReportletConf;
import org.apache.syncope.common.lib.report.ReportletConf;
import org.apache.syncope.common.lib.search.AbstractFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public class ReportletDirectoryPanel
extends DirectoryPanel<ReportletWrapper, ReportletWrapper, DirectoryDataProvider<ReportletWrapper>, ReportRestClient>
implements ModalPanel {
    private static final long serialVersionUID = 4984337552918213290L;
    private final BaseModal<ReportTO> baseModal;
    private final String report;

    public ReportletDirectoryPanel(BaseModal<ReportTO> baseModal, String report, PageReference pageRef) {
        super("content", pageRef, false);
        this.disableCheckBoxes();
        this.baseModal = baseModal;
        this.report = report;
        this.restClient = new ReportRestClient();
        this.enableExitButton();
        this.addNewItemPanelBuilder(new ReportletWizardBuilder(report, new ReportletWrapper(), pageRef), true);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"REPORT_UPDATE");
        this.initResultTable();
    }

    @Override
    protected List<IColumn<ReportletWrapper, String>> getColumns() {
        ArrayList<IColumn<ReportletWrapper, String>> columns = new ArrayList<IColumn<ReportletWrapper, String>>();
        columns.add((IColumn<ReportletWrapper, String>)new PropertyColumn((IModel)new StringResourceModel("reportlet", (Component)this), (Object)"name", "name"));
        columns.add((IColumn<ReportletWrapper, String>)new AbstractColumn<ReportletWrapper, String>((IModel)new StringResourceModel("configuration", (Component)this)){
            private static final long serialVersionUID = -4008579357070833846L;

            public void populateItem(Item<ICellPopulator<ReportletWrapper>> cellItem, String componentId, IModel<ReportletWrapper> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)((ReportletWrapper)rowModel.getObject()).getConf().getClass().getName()))});
            }
        });
        return columns;
    }

    @Override
    public ActionsPanel<ReportletWrapper> getActions(final IModel<ReportletWrapper> model) {
        ActionsPanel<ReportletWrapper> panel = super.getActions(model);
        panel.add(new ActionLink<ReportletWrapper>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, ReportletWrapper ignore) {
                ReportletDirectoryPanel.this.getTogglePanel().close(target);
                AbstractReportletConf clone = (AbstractReportletConf)SerializationUtils.clone((Serializable)((ReportletWrapper)model.getObject()).getConf());
                clone.setName(null);
                ReportletDirectoryPanel.this.send((IEventSink)ReportletDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent<ReportletWrapper>(new ReportletWrapper().setConf(clone), target));
            }
        }, ActionLink.ActionType.CLONE, "REPORT_CREATE");
        panel.add(new ActionLink<ReportletWrapper>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, ReportletWrapper ignore) {
                ReportletDirectoryPanel.this.getTogglePanel().close(target);
                ReportletDirectoryPanel.this.send((IEventSink)ReportletDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent<Serializable>((Serializable)model.getObject(), target));
            }
        }, ActionLink.ActionType.EDIT, "REPORT_UPDATE");
        panel.add(new ActionLink<ReportletWrapper>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, ReportletWrapper ignore) {
                AbstractReportletConf reportlet = ((ReportletWrapper)model.getObject()).getConf();
                try {
                    ReportTO actual = ((ReportRestClient)ReportletDirectoryPanel.this.restClient).read(ReportletDirectoryPanel.this.report);
                    CollectionUtils.filter((Iterable)actual.getReportletConfs(), (Predicate)new Predicate<ReportletConf>((ReportletConf)reportlet){
                        final /* synthetic */ ReportletConf val$reportlet;
                        {
                            this.val$reportlet = reportletConf;
                        }

                        public boolean evaluate(ReportletConf object) {
                            return !object.getName().equals(this.val$reportlet.getName());
                        }
                    });
                    ((ReportRestClient)ReportletDirectoryPanel.this.restClient).update(actual);
                    SyncopeConsoleSession.get().info((Serializable)((Object)ReportletDirectoryPanel.this.getString("operation_succeeded")));
                    ReportletDirectoryPanel.this.customActionOnFinishCallback(target);
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting {}", (Object)reportlet.getName(), (Object)e);
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
                }
                ((BasePage)ReportletDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "REPORT_DELETE", true);
        return panel;
    }

    @Override
    public ActionsPanel<Serializable> getHeader(String componentId) {
        ActionsPanel<Serializable> panel = new ActionsPanel<Serializable>(componentId, null);
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                if (target != null) {
                    ReportletDirectoryPanel.this.customActionOnFinishCallback(target);
                }
            }
        }, ActionLink.ActionType.RELOAD, "TASK_LIST").hideLabel();
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBulkActions() {
        ArrayList<ActionLink.ActionType> bulkActions = new ArrayList<ActionLink.ActionType>();
        bulkActions.add(ActionLink.ActionType.DELETE);
        return bulkActions;
    }

    @Override
    protected ReportDataProvider dataProvider() {
        return new ReportDataProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "reportlet.paginator.rows";
    }

    @Override
    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof WizardMgtPanel.ExitEvent && this.modal != null) {
            AjaxRequestTarget target = ((WizardMgtPanel.ExitEvent)WizardMgtPanel.ExitEvent.class.cast(event.getPayload())).getTarget();
            this.baseModal.show(false);
            this.baseModal.close((IPartialPageRequestHandler)target);
        }
    }

    public static class ReportletWrapper
    implements Serializable {
        private static final long serialVersionUID = 2472755929742424558L;
        private String oldname;
        private String name;
        private AbstractReportletConf conf;
        private final Map<String, Pair<AbstractFiqlSearchConditionBuilder, List<SearchClause>>> scondWrapper;

        public ReportletWrapper() {
            this(null);
        }

        public ReportletWrapper(String name) {
            this.oldname = name;
            this.scondWrapper = new HashMap<String, Pair<AbstractFiqlSearchConditionBuilder, List<SearchClause>>>();
        }

        public boolean isNew() {
            return this.oldname == null;
        }

        public String getOldName() {
            return this.oldname;
        }

        public String getName() {
            return this.name;
        }

        public ReportletWrapper setName(String name) {
            this.name = name;
            return this;
        }

        public AbstractReportletConf getConf() {
            return this.conf;
        }

        public ReportletWrapper setConf(AbstractReportletConf conf) {
            this.conf = conf;
            return this;
        }

        public Map<String, Pair<AbstractFiqlSearchConditionBuilder, List<SearchClause>>> getSCondWrapper() {
            return this.scondWrapper;
        }
    }

    protected class ReportDataProvider
    extends DirectoryDataProvider<ReportletWrapper> {
        private static final long serialVersionUID = 4725679400450513556L;
        private final SortableDataProviderComparator<ReportletWrapper> comparator;

        public ReportDataProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("name", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<ReportletWrapper>(this);
        }

        public Iterator<ReportletWrapper> iterator(long first, long count) {
            ReportTO actual = ((ReportRestClient)ReportletDirectoryPanel.this.restClient).read(ReportletDirectoryPanel.this.report);
            ArrayList reportlets = (ArrayList)CollectionUtils.collect((Iterable)actual.getReportletConfs(), (Transformer)new Transformer<AbstractReportletConf, ReportletWrapper>(){

                public ReportletWrapper transform(AbstractReportletConf input) {
                    return new ReportletWrapper(input.getName()).setName(input.getName()).setConf(input);
                }
            }, new ArrayList());
            Collections.sort(reportlets, this.comparator);
            return reportlets.subList((int)first, (int)(first + count)).iterator();
        }

        public long size() {
            ReportTO actual = ((ReportRestClient)ReportletDirectoryPanel.this.restClient).read(ReportletDirectoryPanel.this.report);
            return actual.getReportletConfs().size();
        }

        public IModel<ReportletWrapper> model(ReportletWrapper object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

