/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.client.console.panels.SchemaTypePanel;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class SchemasPanel
extends Panel {
    private static final long serialVersionUID = -1140213992451232279L;
    private static final String SEARCH_SUBMIT_LINK = "searchSubmitLink";
    private final PageReference pageReference;

    public SchemasPanel(String id, PageReference pageRef) {
        super(id);
        this.pageReference = pageRef;
        final Model keywordModel = new Model((Serializable)((Object)""));
        WebMarkupContainer searchBoxContainer = new WebMarkupContainer("searchBox");
        this.add(new Component[]{searchBoxContainer});
        Form form = new Form("form");
        searchBoxContainer.add(new Component[]{form});
        AjaxTextFieldPanel searchPanel = new AjaxTextFieldPanel("filter", "filter", (IModel<String>)keywordModel, true);
        form.add(new Component[]{searchPanel.hideLabel().setOutputMarkupId(true)});
        AjaxSubmitLink submitLink = new AjaxSubmitLink("search"){
            private static final long serialVersionUID = -1765773642975892072L;

            protected void onAfterSubmit(AjaxRequestTarget target, Form<?> form) {
                super.onAfterSubmit(target, form);
                this.send((IEventSink)SchemasPanel.this, Broadcast.DEPTH, new SchemaTypePanel.SchemaSearchEvent(target, (String)((Object)keywordModel.getObject())));
            }
        };
        submitLink.setOutputMarkupId(true);
        submitLink.setMarkupId(SEARCH_SUBMIT_LINK);
        form.add(new Component[]{submitLink});
        searchPanel.getField().add(new Behavior[]{AttributeModifier.replace((String)"onkeydown", (IModel)Model.of((Serializable)((Object)"if(event.keyCode == 13) {event.preventDefault();}")))});
        searchPanel.getField().add(new Behavior[]{new AjaxEventBehavior("onkeydown"){
            private static final long serialVersionUID = -7133385027739964990L;

            protected void onEvent(AjaxRequestTarget target) {
                target.appendJavaScript((CharSequence)"$('#searchSubmitLink').click();");
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.getAjaxCallListeners().add(new AjaxCallListener(){
                    private static final long serialVersionUID = 7160235486520935153L;

                    public CharSequence getPrecondition(Component component) {
                        return "if (Wicket.Event.keyCode(attrs.event)  == 13) { return true; } else { return false; }";
                    }
                });
            }
        }});
        Accordion accordion = new Accordion("accordionPanel", this.buildTabList());
        accordion.setOutputMarkupId(true);
        this.add(new Component[]{accordion});
    }

    private List<ITab> buildTabList() {
        ArrayList<ITab> tabs = new ArrayList<ITab>();
        for (final SchemaType schemaType : SchemaType.values()) {
            tabs.add((ITab)new AbstractTab((IModel)new Model((Serializable)((Object)schemaType.name()))){
                private static final long serialVersionUID = 1037272333056449378L;

                public Panel getPanel(String panelId) {
                    return new SchemaTypePanel(panelId, schemaType, SchemasPanel.this.pageReference);
                }
            });
        }
        return tabs;
    }
}

