/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import org.apache.syncope.client.console.panels.RealmDetails;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.wizards.AjaxWizardBuilder;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;

public class RealmWizardBuilder
extends AjaxWizardBuilder<RealmTO> {
    private static final long serialVersionUID = 5945391813567245081L;
    private final RealmRestClient realmRestClient = new RealmRestClient();
    private String parentPath;

    public RealmWizardBuilder(PageReference pageRef) {
        super(new RealmTO(), pageRef);
    }

    @Override
    protected Serializable onApplyInternal(RealmTO modelObject) {
        ProvisioningResult<RealmTO> res = modelObject.getKey() == null ? this.realmRestClient.create(this.parentPath, modelObject) : this.realmRestClient.update(modelObject);
        return res;
    }

    @Override
    protected WizardModel buildModelSteps(RealmTO modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Realm(modelObject));
        return wizardModel;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public static class Realm
    extends WizardStep {
        private static final long serialVersionUID = -2123790676338327104L;

        public Realm(RealmTO modelObject) {
            RealmDetails realmDetail = new RealmDetails("details", modelObject);
            realmDetail.add(new Behavior[]{new AttributeAppender("style", (Serializable)((Object)"overflow-x:hidden;"))});
            this.add(new Component[]{realmDetail});
        }
    }
}

