/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.ProvisionTO;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvisionAuxClassesPanel
extends Panel {
    private static final long serialVersionUID = -3962956154520358784L;
    private static final Logger LOG = LoggerFactory.getLogger(ProvisionAuxClassesPanel.class);
    private final ProvisionTO provision;

    public ProvisionAuxClassesPanel(String id, ProvisionTO provision) {
        super(id);
        this.setOutputMarkupId(true);
        this.provision = provision;
    }

    protected void onBeforeRender() {
        List choices;
        ListModel model;
        super.onBeforeRender();
        if (this.provision == null) {
            model = new ListModel(Collections.emptyList());
            choices = Collections.emptyList();
        } else {
            model = new PropertyModel((Object)this.provision, "auxClasses");
            choices = new ArrayList();
            AnyTypeTO anyType = null;
            try {
                anyType = new AnyTypeRestClient().read(this.provision.getAnyType());
            }
            catch (Exception e) {
                LOG.error("Could not read AnyType {}", (Object)this.provision.getAnyType(), (Object)e);
            }
            if (anyType != null) {
                for (AnyTypeClassTO aux : new AnyTypeClassRestClient().list()) {
                    if (anyType.getClasses().contains(aux.getKey())) continue;
                    choices.add(aux.getKey());
                }
            }
        }
        this.addOrReplace(new Component[]{new AjaxPalettePanel.Builder().build("auxClasses", model, new ListModel(choices)).hideLabel().setOutputMarkupId(true).setEnabled(this.provision != null)});
    }
}

