/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultilevelPanel
extends Panel
implements IHeaderContributor {
    private static final long serialVersionUID = -4064294905566247729L;
    protected static final Logger LOG = LoggerFactory.getLogger(MultilevelPanel.class);
    private boolean isFirstLevel = true;
    public static final String FIRST_LEVEL_ID = "first";
    public static final String SECOND_LEVEL_ID = "second";
    private final WebMarkupContainer firstLevelContainer = new WebMarkupContainer("firstLevelContainer");
    private final WebMarkupContainer secondLevelContainer;

    public MultilevelPanel(String id) {
        super(id);
        this.firstLevelContainer.setOutputMarkupPlaceholderTag(true);
        this.firstLevelContainer.setVisible(true);
        this.add(new Component[]{this.firstLevelContainer});
        this.secondLevelContainer = new WebMarkupContainer("secondLevelContainer");
        this.secondLevelContainer.setOutputMarkupPlaceholderTag(true);
        this.secondLevelContainer.setVisible(false);
        this.add(new Component[]{this.secondLevelContainer});
        this.secondLevelContainer.add(new Component[]{new AjaxLink<String>("back"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                MultilevelPanel.this.onClickBackInternal(target);
                MultilevelPanel.this.prev(target);
            }
        }});
    }

    public final void next(String title, SecondLevel secondLevel, AjaxRequestTarget target) {
        if (this.isFirstLevel) {
            this.secondLevelContainer.addOrReplace(new Component[]{new Label("title", (IModel)new ResourceModel(title, title))});
            this.secondLevelContainer.addOrReplace(new Component[]{secondLevel});
            this.secondLevelContainer.setVisible(true);
            target.add(new Component[]{this.secondLevelContainer});
            this.firstLevelContainer.setVisible(false);
            target.add(new Component[]{this.firstLevelContainer});
            this.isFirstLevel = false;
        } else {
            LOG.warn("No further level available");
        }
    }

    protected void prev(AjaxRequestTarget target) {
        if (this.isFirstLevel) {
            LOG.warn("No further level available");
        } else {
            this.firstLevelContainer.setVisible(true);
            target.add(new Component[]{this.firstLevelContainer});
            this.secondLevelContainer.setVisible(false);
            target.add(new Component[]{this.secondLevelContainer});
            this.isFirstLevel = true;
        }
    }

    protected void onClickBackInternal(AjaxRequestTarget taget) {
    }

    public MultilevelPanel setFirstLevel(Panel panel) {
        this.firstLevelContainer.addOrReplace(new Component[]{panel});
        return this;
    }

    public static class SecondLevel
    extends Panel {
        private static final long serialVersionUID = 5685291231060035528L;

        public SecondLevel() {
            this(MultilevelPanel.SECOND_LEVEL_ID);
        }

        public SecondLevel(String id) {
            super(id);
        }
    }
}

