/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.panels.ListViewPanel;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.CollectionPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;

public abstract class ConnObjectListViewPanel
extends Panel {
    private static final long serialVersionUID = 4986172040062752781L;
    private static final int SIZE = 10;
    private String nextPageCookie;

    protected ConnObjectListViewPanel(String id, final String resource, final String anyType, PageReference pageRef) {
        super(id);
        List<ConnObjectTO> listOfItems = this.reloadItems(resource, anyType, null);
        ListViewPanel.Builder<ConnObjectTO> builder = new ListViewPanel.Builder<ConnObjectTO>(ConnObjectTO.class, pageRef){
            private static final long serialVersionUID = -8251750413385566738L;

            @Override
            protected Component getValueComponent(final String key, ConnObjectTO bean) {
                AttrTO attrTO = (AttrTO)IterableUtils.find((Iterable)bean.getAttrs(), (Predicate)new Predicate<AttrTO>(){

                    public boolean evaluate(AttrTO object) {
                        return object.getSchema().equals(key);
                    }
                });
                return attrTO == null || CollectionUtils.isEmpty((Collection)attrTO.getValues()) ? new Label("field", (Serializable)((Object)"")) : new CollectionPanel("field", attrTO.getValues());
            }
        };
        builder.setReuseItem(false);
        builder.addAction(new ActionLink<ConnObjectTO>(){
            private static final long serialVersionUID = 7511002881490248598L;

            @Override
            public void onClick(AjaxRequestTarget target, ConnObjectTO modelObject) {
                ConnObjectListViewPanel.this.viewConnObject(modelObject, target);
            }
        }, ActionLink.ActionType.VIEW, "RESOURCE_GET_CONNOBJECT").setItems(listOfItems).includes("__UID__", "__NAME__", "__ENABLE__").withChecks(ListViewPanel.CheckAvailability.NONE).setReuseItem(false);
        this.add(new Component[]{builder.build("objs")});
        final WebMarkupContainer arrows = new WebMarkupContainer("arrows");
        this.add(new Component[]{arrows.setOutputMarkupId(true)});
        arrows.add(new Component[]{new AjaxLink<Serializable>("next"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                List listOfItems = ConnObjectListViewPanel.this.reloadItems(resource, anyType, ConnObjectListViewPanel.this.nextPageCookie);
                target.add(new Component[]{arrows});
                this.send((IEventSink)ConnObjectListViewPanel.this, Broadcast.DEPTH, new ListViewPanel.ListViewReload(listOfItems, target));
            }

            public boolean isVisible() {
                return ConnObjectListViewPanel.this.nextPageCookie != null;
            }
        }});
    }

    protected abstract void viewConnObject(ConnObjectTO var1, AjaxRequestTarget var2);

    private List<ConnObjectTO> reloadItems(String resource, String anyType, String cookie) {
        Pair<String, List<ConnObjectTO>> items = new ResourceRestClient().listConnObjects(resource, anyType, 10, cookie, (SortParam<String>)new SortParam((Object)"__UID__", true));
        this.nextPageCookie = (String)items.getLeft();
        return (List)items.getRight();
    }
}

