/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.ConfRestClient;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;

public class AnyTypeClassDetailsPanel
extends Panel {
    private static final long serialVersionUID = 3321861543207340469L;
    private final AnyTypeClassTO anyTypeClassTO;
    private final SchemaRestClient schemaRestClient = new SchemaRestClient();
    private final List<String> availablePlainSchemas = this.schemaRestClient.getPlainSchemaNames();
    private final List<String> availableDerSchemas = this.schemaRestClient.getDerSchemaNames();
    private final List<String> availableVirSchemas = this.schemaRestClient.getVirSchemaNames();
    private static final List<String> LAYOUT_PARAMETERS = Arrays.asList("admin.user.layout", "self.user.layout", "admin.group.layout", "self.group.layout", "admin.membership.layout", "self.membership.layout");

    public AnyTypeClassDetailsPanel(String id, AnyTypeClassTO anyTypeClassTO) {
        super(id);
        this.anyTypeClassTO = anyTypeClassTO;
        this.buildAvailableSchemas(anyTypeClassTO.getKey());
        Form antTypeClassForm = new Form("form");
        antTypeClassForm.setModel((IModel)new CompoundPropertyModel((Object)anyTypeClassTO));
        antTypeClassForm.setOutputMarkupId(true);
        this.add(new Component[]{antTypeClassForm});
        AjaxTextFieldPanel key = new AjaxTextFieldPanel("key", this.getString("key"), (IModel<String>)new PropertyModel((Object)this.anyTypeClassTO, "key"));
        key.addRequiredLabel();
        key.setEnabled(anyTypeClassTO.getKey() == null || this.anyTypeClassTO.getKey().isEmpty());
        antTypeClassForm.add(new Component[]{key});
        WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        antTypeClassForm.add(new Component[]{container});
        AjaxPalettePanel plainSchema = new AjaxPalettePanel.Builder().setAllowOrder(true).setAllowMoveAll(true).build("plainSchemas", new PropertyModel((Object)this.anyTypeClassTO, "plainSchemas"), new ListModel(this.availablePlainSchemas));
        plainSchema.hideLabel();
        plainSchema.setOutputMarkupId(true);
        container.add(new Component[]{plainSchema});
        AjaxPalettePanel derSchema = new AjaxPalettePanel.Builder().setAllowOrder(true).setAllowMoveAll(true).build("derSchemas", new PropertyModel((Object)this.anyTypeClassTO, "derSchemas"), new ListModel(this.availableDerSchemas));
        derSchema.hideLabel();
        derSchema.setOutputMarkupId(true);
        container.add(new Component[]{derSchema});
        AjaxPalettePanel virSchema = new AjaxPalettePanel.Builder().setAllowOrder(true).setAllowMoveAll(true).build("virSchemas", new PropertyModel((Object)this.anyTypeClassTO, "virSchemas"), new ListModel(this.availableVirSchemas));
        virSchema.hideLabel();
        virSchema.setOutputMarkupId(true);
        container.add(new Component[]{virSchema});
    }

    private void buildAvailableSchemas(String key) {
        ArrayList configurationSchemas = new ArrayList();
        CollectionUtils.collect(new ConfRestClient().list(), (Transformer)new Transformer<AttrTO, String>(){

            public String transform(AttrTO attrTO) {
                return attrTO.getSchema();
            }
        }, configurationSchemas);
        for (AnyTypeClassTO item : new AnyTypeClassRestClient().list()) {
            if (key != null && item.getKey().equals(key)) continue;
            this.availablePlainSchemas.removeAll(item.getPlainSchemas());
            this.availableDerSchemas.removeAll(item.getDerSchemas());
            this.availableVirSchemas.removeAll(item.getVirSchemas());
        }
        this.availablePlainSchemas.removeAll(configurationSchemas);
        this.availablePlainSchemas.removeAll(LAYOUT_PARAMETERS);
    }
}

