/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.pages;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import org.apache.syncope.client.console.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.pages.Dashboard;
import org.apache.syncope.client.console.panels.Realm;
import org.apache.syncope.client.console.panels.RealmChoicePanel;
import org.apache.syncope.client.console.panels.WizardModalPanel;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.tasks.TemplatesTogglePanel;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.any.ResultPage;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.TemplatableTO;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class Realms
extends BasePage {
    private static final long serialVersionUID = -1100228004207271270L;
    private final RealmRestClient realmRestClient = new RealmRestClient();
    private final TemplatesTogglePanel templates = new TemplatesTogglePanel("content", (MarkupContainer)this, this.getPageReference()){
        private static final long serialVersionUID = 4828350561653999922L;

        @Override
        protected Serializable onApplyInternal(TemplatableTO targetObject, String type, AnyTO anyTO) {
            targetObject.getTemplates().put(type, anyTO);
            new RealmRestClient().update((RealmTO)RealmTO.class.cast(targetObject));
            return targetObject;
        }
    };
    private final RealmChoicePanel realmChoicePanel;
    private final WebMarkupContainer content;
    private final BaseModal<RealmTO> modal;
    private final BaseModal<Serializable> templateModal;

    public Realms(PageParameters parameters) {
        super(parameters);
        this.body.add(new Component[]{BookmarkablePageLinkBuilder.build("dashboard", "dashboardBr", Dashboard.class)});
        this.content = new WebMarkupContainer("content");
        this.realmChoicePanel = new RealmChoicePanel("realmChoicePanel", this.getPageReference());
        this.realmChoicePanel.setOutputMarkupId(true);
        this.content.add(new Component[]{this.realmChoicePanel});
        this.content.add(new Component[]{new Label("body", (Serializable)((Object)"Root realm"))});
        this.content.setOutputMarkupId(true);
        this.body.add(new Component[]{this.content});
        this.modal = new BaseModal("modal");
        this.modal.size(Modal.Size.Large);
        this.content.add(new Component[]{this.modal});
        this.content.add(new Component[]{this.templates});
        this.templateModal = new BaseModal<Serializable>("templateModal"){
            private static final long serialVersionUID = 5787433530654262016L;

            protected void onConfigure() {
                super.onConfigure();
                this.setFooterVisible(false);
            }
        };
        this.templateModal.size(Modal.Size.Large);
        this.content.add(new Component[]{this.templateModal});
        this.modal.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                target.add(new Component[]{Realms.this.realmChoicePanel.reloadRealmTree(target)});
                target.add(new Component[]{Realms.this.content});
                Realms.this.modal.show(false);
            }
        });
        this.templateModal.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                target.add(new Component[]{Realms.this.content});
                Realms.this.templateModal.show(false);
            }
        });
        try {
            this.updateRealmContent(this.realmChoicePanel.getCurrentRealm(), parameters.get("selectedIndex").toInteger());
        }
        catch (Exception e) {
            LOG.debug("Unexpected error", (Throwable)e);
            this.updateRealmContent(this.realmChoicePanel.getCurrentRealm(), 0);
        }
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof RealmChoicePanel.ChosenRealm) {
            RealmChoicePanel.ChosenRealm choosenRealm = (RealmChoicePanel.ChosenRealm)RealmChoicePanel.ChosenRealm.class.cast(event.getPayload());
            this.updateRealmContent((RealmTO)choosenRealm.getObj(), 0);
            choosenRealm.getTarget().add(new Component[]{this.content});
        } else if (event.getPayload() instanceof AjaxWizard.NewItemEvent) {
            AjaxWizard.NewItemEvent newItemEvent = (AjaxWizard.NewItemEvent)AjaxWizard.NewItemEvent.class.cast(event.getPayload());
            WizardModalPanel<?> modalPanel = newItemEvent.getModalPanel();
            if (event.getPayload() instanceof AjaxWizard.NewItemActionEvent && modalPanel != null) {
                CompoundPropertyModel model = new CompoundPropertyModel(modalPanel.getItem());
                this.templateModal.setFormModel((IModel<Serializable>)model);
                this.templateModal.header(newItemEvent.getResourceModel());
                newItemEvent.getTarget().add(new Component[]{this.templateModal.setContent(modalPanel)});
                this.templateModal.show(true);
            } else if (event.getPayload() instanceof AjaxWizard.NewItemCancelEvent) {
                this.templateModal.close((IPartialPageRequestHandler)newItemEvent.getTarget());
            } else if (event.getPayload() instanceof AjaxWizard.NewItemFinishEvent) {
                SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
                ((BasePage)this.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)newItemEvent.getTarget());
                this.templateModal.close((IPartialPageRequestHandler)newItemEvent.getTarget());
            }
        }
    }

    private WebMarkupContainer updateRealmContent(final RealmTO realmTO, final int selectedIndex) {
        if (realmTO == null) {
            return this.content;
        }
        this.content.addOrReplace(new Component[]{new Realm("body", realmTO, this.getPageReference(), selectedIndex){
            private static final long serialVersionUID = 8221398624379357183L;

            @Override
            protected void onClickTemplate(AjaxRequestTarget target) {
                Realms.this.templates.setTargetObject((TemplatableTO)realmTO);
                Realms.this.templates.toggle(target, true);
            }

            @Override
            protected void setWindowClosedReloadCallback(final BaseModal<?> modal) {
                modal.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
                    private static final long serialVersionUID = 8804221891699487139L;

                    public void onClose(AjaxRequestTarget target) {
                        if (modal.getContent() instanceof ResultPage) {
                            Serializable result = ((ResultPage)ResultPage.class.cast(modal.getContent())).getResult();
                            RealmTO newRealmTO = (RealmTO)RealmTO.class.cast(((ProvisioningResult)ProvisioningResult.class.cast(result)).getEntity());
                            target.add(new Component[]{Realms.this.realmChoicePanel.reloadRealmTree(target, (Model<RealmTO>)Model.of((Serializable)newRealmTO))});
                            Realms.this.realmChoicePanel.setCurrentRealm(newRealmTO);
                            this.send((IEventSink)Realms.this, Broadcast.DEPTH, new RealmChoicePanel.ChosenRealm<RealmTO>(newRealmTO, target));
                        } else {
                            target.add(new Component[]{Realms.this.realmChoicePanel.reloadRealmTree(target)});
                        }
                        target.add(new Component[]{Realms.this.content});
                        modal.show(false);
                    }
                });
            }

            @Override
            protected void onClickCreate(AjaxRequestTarget target) {
                this.wizardBuilder.setParentPath(Realms.this.realmChoicePanel.getCurrentRealm().getFullPath());
                this.send((IEventSink)this, Broadcast.EXACT, new AjaxWizard.NewItemActionEvent<RealmTO>(new RealmTO(), target){

                    @Override
                    public String getEventDescription() {
                        return "realm.new";
                    }
                });
            }

            @Override
            protected void onClickEdit(AjaxRequestTarget target, RealmTO realmTO2) {
                this.wizardBuilder.setParentPath(realmTO2.getFullPath());
                this.send((IEventSink)this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent<RealmTO>(realmTO2, target){

                    @Override
                    public String getEventDescription() {
                        return "realm.edit";
                    }
                });
            }

            @Override
            protected void onClickDelete(AjaxRequestTarget target, RealmTO realmTO2) {
                try {
                    if (realmTO2.getKey() == null) {
                        throw new Exception("Root realm cannot be deleted");
                    }
                    Realms.this.realmRestClient.delete(realmTO2.getFullPath());
                    RealmTO parent = Realms.this.realmChoicePanel.moveToParentRealm(realmTO2.getKey());
                    target.add(new Component[]{Realms.this.realmChoicePanel.reloadRealmTree(target)});
                    SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
                    Realms.this.updateRealmContent(parent, selectedIndex);
                    target.add(new Component[]{Realms.this.content});
                }
                catch (Exception e) {
                    LOG.error("While deleting realm", (Throwable)e);
                    SyncopeConsoleSession.get().error((Serializable)((Object)e.getMessage().replace("\n", " ")));
                }
                ((BasePage)Realms.this.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }});
        return this.content;
    }

    public RealmChoicePanel getRealmChoicePanel() {
        return this.realmChoicePanel;
    }
}

