/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.list.SetUniqueList;
import org.apache.syncope.client.console.panels.LogStatementPanel;
import org.apache.syncope.client.console.rest.LoggerRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.common.lib.log.LogStatementTO;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.AjaxSelfUpdatingTimerBehavior;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogViewer
extends WebPage {
    private static final Logger LOG = LoggerFactory.getLogger(LogViewer.class);
    private static final int MAX_STATEMENTS_PER_APPENDER = 50;
    private static final long serialVersionUID = -7578329899052708105L;
    private final LoggerRestClient restClient = new LoggerRestClient();

    public LogViewer() {
        WebMarkupContainer viewer = new WebMarkupContainer("viewer");
        viewer.setOutputMarkupId(true);
        this.add(new Component[]{viewer});
        final AjaxDropDownChoicePanel<String> appenders = new AjaxDropDownChoicePanel<String>("appenders", "Appender", (IModel<String>)new Model(), false);
        MetaDataRoleAuthorizationStrategy.authorize(appenders, (Action)ENABLE, (String)"LOG_READ");
        appenders.setChoices(this.restClient.listMemoryAppenders());
        viewer.add(new Component[]{appenders});
        final WebMarkupContainer stContainer = new WebMarkupContainer("stContainer");
        stContainer.setOutputMarkupId(true);
        viewer.add(new Component[]{stContainer});
        final Model lastTimeInMillis = Model.of((Serializable)Long.valueOf(0L));
        ListModel statementViewModel = new ListModel(new ArrayList());
        ListView<LogStatementTO> statementView = new ListView<LogStatementTO>("statements", (IModel)statementViewModel){
            private static final long serialVersionUID = -9180479401817023838L;

            protected void populateItem(ListItem<LogStatementTO> item) {
                LogStatementPanel panel = new LogStatementPanel("statement", (LogStatementTO)item.getModelObject());
                panel.setOutputMarkupId(true);
                item.add(new Component[]{panel});
            }
        };
        statementView.setOutputMarkupId(true);
        stContainer.add(new Component[]{statementView});
        stContainer.add(new Behavior[]{new AjaxSelfUpdatingTimerBehavior(Duration.seconds((int)10), (ListView)statementView, (IModel)statementViewModel){
            private static final long serialVersionUID = 7298597675929755960L;
            final /* synthetic */ ListView val$statementView;
            final /* synthetic */ IModel val$statementViewModel;
            {
                this.val$statementView = listView;
                this.val$statementViewModel = iModel;
                super(x0);
            }

            protected void onPostProcessTarget(AjaxRequestTarget target) {
                ArrayList recentLogStatements;
                target.prependJavaScript((CharSequence)String.format("window.scrollTop = $('#%s').scrollTop();", stContainer.getMarkupId()));
                List<Object> list = recentLogStatements = appenders.getModelObject() == null ? new ArrayList() : LogViewer.this.restClient.getLastLogStatements((String)appenders.getModelObject(), (Long)lastTimeInMillis.getObject());
                if (!recentLogStatements.isEmpty()) {
                    lastTimeInMillis.setObject((Serializable)Long.valueOf(((LogStatementTO)recentLogStatements.get(recentLogStatements.size() - 1)).getTimeMillis()));
                    int currentSize = this.val$statementView.getModelObject().size();
                    int recentSize = recentLogStatements.size();
                    SetUniqueList newModelObject = SetUniqueList.setUniqueList(new ArrayList(50));
                    if (currentSize <= 50 - recentSize) {
                        newModelObject.addAll(this.val$statementView.getModelObject());
                    } else {
                        newModelObject.addAll(this.val$statementView.getModelObject().subList(currentSize - (50 - recentSize), currentSize));
                    }
                    newModelObject.addAll(recentLogStatements);
                    this.val$statementViewModel.setObject((Object)newModelObject);
                    target.add(new Component[]{stContainer});
                }
                target.appendJavaScript((CharSequence)String.format("$('#%s').scrollTop(window.scrollTop);", stContainer.getMarkupId()));
            }
        }});
        appenders.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change", (IModel)statementViewModel, stContainer, lastTimeInMillis){
            private static final long serialVersionUID = -1107858522700306810L;
            final /* synthetic */ IModel val$statementViewModel;
            final /* synthetic */ WebMarkupContainer val$stContainer;
            final /* synthetic */ Model val$lastTimeInMillis;
            {
                this.val$statementViewModel = iModel;
                this.val$stContainer = webMarkupContainer;
                this.val$lastTimeInMillis = model;
                super(x0);
            }

            protected void onUpdate(AjaxRequestTarget target) {
                ArrayList lastStatements = appenders.getModelObject() == null ? new ArrayList() : LogViewer.this.restClient.getLastLogStatements((String)appenders.getModelObject(), 0L);
                this.val$statementViewModel.setObject(lastStatements);
                target.add(new Component[]{this.val$stContainer});
                this.val$lastTimeInMillis.setObject((Serializable)Long.valueOf(0L));
            }
        }});
    }
}

