/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.notifications;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.rest.TemplateRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class TemplateModal<T extends EntityTO, F>
extends AbstractModalPanel<T> {
    private static final long serialVersionUID = 2053048734388383021L;
    private final T templateTO;
    private final TemplateRestClient<T, F> restClient;

    public TemplateModal(BaseModal<T> modal, TemplateRestClient<T, F> restClient, T templateTO, PageReference pageRef) {
        super(modal, pageRef);
        this.restClient = restClient;
        this.templateTO = templateTO;
        AjaxTextFieldPanel key = new AjaxTextFieldPanel("key", "key", (IModel<String>)new PropertyModel(templateTO, "key"), false);
        key.setOutputMarkupPlaceholderTag(true);
        this.add(new Component[]{key.setRenderBodyOnly(true)});
    }

    @Override
    public T getItem() {
        return this.templateTO;
    }

    @Override
    public void onSubmit(AjaxRequestTarget target, Form<?> form) {
        try {
            this.restClient.createTemplate(this.templateTO);
            SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
            this.modal.close((IPartialPageRequestHandler)target);
        }
        catch (SyncopeClientException e) {
            LOG.error("While creating template for {}", (Object)this.templateTO.getKey(), (Object)e);
            SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
        }
        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }
}

