/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.notifications;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.search.AbstractFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.UserFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.NotificationTO;

public class NotificationWrapper
implements Serializable {
    private static final long serialVersionUID = 8058288034211558376L;
    private final NotificationTO notificationTO;
    private List<Pair<String, List<SearchClause>>> aboutClauses;
    private List<SearchClause> recipientClauses;

    public NotificationWrapper(NotificationTO notificationTO) {
        this.notificationTO = notificationTO;
    }

    public final String getKey() {
        return this.notificationTO.getKey();
    }

    public List<Pair<String, List<SearchClause>>> getAboutClauses() {
        if (this.aboutClauses == null) {
            this.aboutClauses = new ArrayList<Pair<String, List<SearchClause>>>();
            for (Map.Entry<String, List<SearchClause>> entry : SearchUtils.getSearchClauses(this.notificationTO.getAbouts()).entrySet()) {
                this.aboutClauses.add((Pair<String, List<SearchClause>>)Pair.of((Object)entry.getKey(), entry.getValue()));
            }
        }
        return this.aboutClauses;
    }

    public void setAboutClauses(List<Pair<String, List<SearchClause>>> dynClauses) {
        this.aboutClauses = dynClauses;
    }

    public List<SearchClause> getRecipientClauses() {
        if (this.recipientClauses == null) {
            this.recipientClauses = SearchUtils.getSearchClauses(this.notificationTO.getRecipientsFIQL());
        }
        return this.recipientClauses;
    }

    public void setRecipientClauses(List<SearchClause> dynClauses) {
        this.recipientClauses = dynClauses;
    }

    public Map<String, String> getAboutFIQLs() {
        if (CollectionUtils.isEmpty(this.aboutClauses)) {
            return this.notificationTO.getAbouts();
        }
        HashMap<String, String> res = new HashMap<String, String>();
        for (Pair<String, List<SearchClause>> pair : this.aboutClauses) {
            UserFiqlSearchConditionBuilder builder;
            switch ((String)pair.getLeft()) {
                case "USER": {
                    builder = SyncopeClient.getUserSearchConditionBuilder();
                    break;
                }
                case "GROUP": {
                    builder = SyncopeClient.getGroupSearchConditionBuilder();
                    break;
                }
                default: {
                    builder = SyncopeClient.getAnyObjectSearchConditionBuilder((String)((String)pair.getLeft()));
                }
            }
            res.put((String)pair.getLeft(), SearchUtils.buildFIQL((List)pair.getRight(), (AbstractFiqlSearchConditionBuilder)builder));
        }
        return res;
    }

    private String getRecipientsFIQL() {
        if (CollectionUtils.isEmpty(this.recipientClauses)) {
            return null;
        }
        return SearchUtils.buildFIQL(this.recipientClauses, (AbstractFiqlSearchConditionBuilder)SyncopeClient.getUserSearchConditionBuilder());
    }

    public NotificationTO fillAboutConditions() {
        this.notificationTO.getAbouts().clear();
        this.notificationTO.getAbouts().putAll(this.getAboutFIQLs());
        return this.notificationTO;
    }

    public NotificationTO fillRecipientConditions() {
        this.notificationTO.setRecipientsFIQL(this.getRecipientsFIQL());
        return this.notificationTO;
    }

    public NotificationTO getInnerObject() {
        return this.notificationTO;
    }
}

