/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.commons.status;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.syncope.client.console.commons.status.ConnObjectWrapper;
import org.apache.syncope.client.console.commons.status.Status;
import org.apache.syncope.client.console.commons.status.StatusBean;
import org.apache.syncope.client.console.panels.LabelPanel;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.StatusPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.PropagationTaskExecStatus;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusUtils
implements Serializable {
    private static final long serialVersionUID = 7238009174387184309L;
    private static final Logger LOG = LoggerFactory.getLogger(StatusUtils.class);
    private final ResourceRestClient restClient = new ResourceRestClient();

    public List<ConnObjectWrapper> getConnectorObjects(AnyTO any) {
        ArrayList<ConnObjectWrapper> objects = new ArrayList<ConnObjectWrapper>();
        objects.addAll(this.getConnectorObjects(any, (Collection<String>)any.getResources()));
        return objects;
    }

    public List<ConnObjectWrapper> getConnectorObjects(Collection<AnyTO> anys, Collection<String> resources) {
        ArrayList<ConnObjectWrapper> objects = new ArrayList<ConnObjectWrapper>();
        for (AnyTO any : anys) {
            objects.addAll(this.getConnectorObjects(any, resources));
        }
        return objects;
    }

    public List<ConnObjectWrapper> getConnectorObjects(AnyTO any, Collection<String> resources) {
        ArrayList<ConnObjectWrapper> objects = new ArrayList<ConnObjectWrapper>();
        for (String resourceName : resources) {
            ConnObjectTO objectTO = null;
            try {
                objectTO = this.restClient.readConnObject(resourceName, any.getType(), any.getKey());
            }
            catch (Exception e) {
                LOG.warn("ConnObject '{}' not found on resource '{}'", (Object)any.getKey(), (Object)resourceName);
            }
            objects.add(new ConnObjectWrapper(any, resourceName, objectTO));
        }
        return objects;
    }

    public StatusBean getStatusBean(AnyTO anyTO, String resourceName, ConnObjectTO objectTO, boolean notUser) {
        StatusBean statusBean = new StatusBean(anyTO, resourceName);
        if (objectTO != null) {
            Boolean enabled = this.isEnabled(objectTO);
            Status status = enabled == null ? (notUser ? Status.ACTIVE : Status.UNDEFINED) : (enabled != false ? Status.ACTIVE : Status.SUSPENDED);
            String connObjectLink = this.getConnObjectLink(objectTO);
            statusBean.setStatus(status);
            statusBean.setConnObjectLink(connObjectLink);
        }
        return statusBean;
    }

    public StatusBean getStatusBean(RealmTO anyTO, String resourceName, ConnObjectTO objectTO) {
        StatusBean statusBean = new StatusBean(anyTO, resourceName);
        if (objectTO != null) {
            Boolean enabled = this.isEnabled(objectTO);
            Status status = enabled == null ? Status.ACTIVE : (enabled != false ? Status.ACTIVE : Status.SUSPENDED);
            String connObjectLink = this.getConnObjectLink(objectTO);
            statusBean.setStatus(status);
            statusBean.setConnObjectLink(connObjectLink);
        }
        return statusBean;
    }

    private Boolean isEnabled(ConnObjectTO objectTO) {
        AttrTO status = objectTO.getAttr("__ENABLE__");
        return status != null && status.getValues() != null && !status.getValues().isEmpty() ? Boolean.valueOf((String)status.getValues().get(0)) : Boolean.FALSE;
    }

    private String getConnObjectLink(ConnObjectTO objectTO) {
        AttrTO name = objectTO == null ? null : objectTO.getAttr("__NAME__");
        return name != null && name.getValues() != null && !name.getValues().isEmpty() ? (String)name.getValues().get(0) : null;
    }

    public static PasswordPatch buildPasswordPatch(String password, Collection<StatusBean> statuses) {
        PasswordPatch.Builder builder = new PasswordPatch.Builder();
        builder.value((Object)password);
        for (StatusBean status : statuses) {
            if ("syncope".equalsIgnoreCase(status.getResource())) {
                builder.onSyncope(true);
                continue;
            }
            builder.resource(status.getResource());
        }
        return (PasswordPatch)builder.build();
    }

    public static StatusPatch buildStatusPatch(Collection<StatusBean> statuses) {
        return StatusUtils.buildStatusPatch(statuses, null);
    }

    public static StatusPatch buildStatusPatch(Collection<StatusBean> statuses, Boolean enable) {
        StatusPatch.Builder builder = new StatusPatch.Builder();
        builder.onSyncope(false);
        for (StatusBean status : statuses) {
            if ("syncope".equalsIgnoreCase(status.getResource())) {
                builder.onSyncope(true);
                continue;
            }
            builder.resource(status.getResource());
        }
        return builder.build();
    }

    public static Panel getStatusImagePanel(String componentId, Status status) {
        return new LabelPanel(componentId, StatusUtils.getStatusImage("label", status));
    }

    public static Label getStatusImage(String componentId, Status status) {
        String clazz;
        String title;
        String alt;
        switch (status) {
            case NOT_YET_SUBMITTED: {
                alt = "undefined icon";
                title = "Not yet submitted";
                clazz = "glyphicon glyphicon-question-sign";
                break;
            }
            case ACTIVE: {
                alt = "active icon";
                title = "Enabled";
                clazz = "glyphicon glyphicon-ok-circle";
                break;
            }
            case UNDEFINED: {
                alt = "undefined icon";
                title = "Undefined status";
                clazz = "glyphicon glyphicon-question-sign";
                break;
            }
            case OBJECT_NOT_FOUND: {
                alt = "notfound icon";
                title = "Not found";
                clazz = "glyphicon glyphicon-remove-circle";
                break;
            }
            case CREATED: {
                alt = "created icon";
                title = "Created";
                clazz = "glyphicon glyphicon-question-sign";
                break;
            }
            case SUSPENDED: {
                alt = "inactive icon";
                title = "Disabled";
                clazz = "glyphicon glyphicon-ban-circle";
                break;
            }
            default: {
                alt = "";
                title = "";
                clazz = "";
            }
        }
        return StatusUtils.getLabel(componentId, alt, title, clazz);
    }

    public static Panel getStatusImagePanel(String componentId, PropagationTaskExecStatus status) {
        return new LabelPanel(componentId, StatusUtils.getStatusImage("label", status));
    }

    public static Label getStatusImage(String componentId, PropagationTaskExecStatus status) {
        String clazz;
        String title;
        String alt;
        switch (status) {
            case NOT_ATTEMPTED: {
                alt = "not attempted";
                title = "Not attempted";
                clazz = "glyphicon glyphicon-question-sign";
                break;
            }
            case CREATED: {
                alt = "created icon";
                title = "Created";
                clazz = "glyphicon glyphicon-ok-circle";
                break;
            }
            case SUCCESS: {
                alt = "success icon";
                title = "Propagation succeded";
                clazz = "glyphicon glyphicon-ok-circle";
                break;
            }
            case FAILURE: {
                alt = "failure icon";
                title = "Propagation failed";
                clazz = "glyphicon glyphicon-remove-circle";
                break;
            }
            default: {
                alt = "";
                title = "";
                clazz = "";
            }
        }
        return StatusUtils.getLabel(componentId, alt, title, clazz);
    }

    private static Label getLabel(String componentId, final String alt, final String title, final String clazz) {
        return new Label(componentId, (Serializable)((Object)"")){
            private static final long serialVersionUID = 4755868673082976208L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("alt", (CharSequence)alt);
                tag.put("title", (CharSequence)title);
                tag.put("class", (CharSequence)clazz);
            }
        };
    }
}

