/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.approvals;

import java.io.Serializable;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.approvals.Approval;
import org.apache.syncope.client.console.approvals.ApprovalDetails;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.panels.SubmitableModalPanel;
import org.apache.syncope.client.console.panels.WizardModalPanel;
import org.apache.syncope.client.console.rest.UserWorkflowRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.common.lib.to.WorkflowFormTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;

public class ApprovalModal
extends Panel
implements SubmitableModalPanel,
WizardModalPanel<WorkflowFormTO> {
    private static final long serialVersionUID = -8847854414429745216L;
    private final BaseModal<?> modal;
    private final WorkflowFormTO formTO;
    private final PageReference pageRef;

    public ApprovalModal(BaseModal<?> modal, final PageReference pageRef, WorkflowFormTO formTO) {
        super("content");
        this.modal = modal;
        this.formTO = formTO;
        this.pageRef = pageRef;
        final MultilevelPanel mlp = new MultilevelPanel("approval");
        this.add(new Component[]{mlp});
        mlp.setFirstLevel(new Approval(pageRef, formTO){
            private static final long serialVersionUID = -2195387360323687302L;

            @Override
            protected void viewDetails(WorkflowFormTO formTO, AjaxRequestTarget target) {
                mlp.next(this.getString("approval.details"), new ApprovalDetails(pageRef, formTO), target);
            }
        });
    }

    @Override
    public void onSubmit(AjaxRequestTarget target, Form<?> form) {
        new UserWorkflowRestClient().submitForm(this.formTO);
        this.modal.show(false);
        this.modal.close((IPartialPageRequestHandler)target);
        SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
    }

    @Override
    public void onError(AjaxRequestTarget target, Form<?> form) {
        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }

    @Override
    public WorkflowFormTO getItem() {
        return this.formTO;
    }
}

