/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.slider.util;

import de.agilecoders.wicket.extensions.slider.ISliderValue;
import de.agilecoders.wicket.extensions.slider.util.INumericValue;

public class IntegerValue
implements ISliderValue,
INumericValue<Integer> {
    private int value;

    public IntegerValue() {
    }

    public IntegerValue(int value) {
        this.value = value;
    }

    @Override
    public ISliderValue fromString(String value) {
        return new IntegerValue(Integer.parseInt(value));
    }

    @Override
    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public void setValue(Integer value) {
        this.value = value;
    }

    @Override
    public Class<? extends Number> getNumberType() {
        return Integer.class;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntegerValue)) {
            return false;
        }
        IntegerValue longValue = (IntegerValue)o;
        return this.value == longValue.value;
    }

    public int hashCode() {
        return this.value ^ this.value >>> 32;
    }
}

