/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.navigation.ajax;

import de.agilecoders.wicket.core.markup.html.bootstrap.navigation.BootstrapPagingNavigator;
import de.agilecoders.wicket.core.markup.html.bootstrap.navigation.ajax.BootstrapAjaxPagingNavigationBehavior;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.IAjaxLink;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigation;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigationBehavior;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigationIncrementLink;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigationLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.navigation.paging.IPagingLabelProvider;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigation;
import org.apache.wicket.markup.repeater.AbstractRepeater;

public class BootstrapAjaxPagingNavigator
extends BootstrapPagingNavigator {
    private final IPageable pageable;

    public BootstrapAjaxPagingNavigator(String id, IPageable pageable) {
        this(id, pageable, null);
    }

    public BootstrapAjaxPagingNavigator(String id, IPageable pageable, IPagingLabelProvider labelProvider) {
        super(id, pageable, labelProvider);
        this.pageable = pageable;
        this.setOutputMarkupId(true);
    }

    protected AbstractLink newPagingNavigationIncrementLink(String id, IPageable pageable, int increment) {
        return new AjaxPagingNavigationIncrementLink(id, pageable, increment){

            protected AjaxPagingNavigationBehavior newAjaxPagingNavigationBehavior(IPageable pageable, String event) {
                return new BootstrapAjaxPagingNavigationBehavior((IAjaxLink)this, pageable, event);
            }
        };
    }

    protected AbstractLink newPagingNavigationLink(String id, IPageable pageable, int pageNumber) {
        return new AjaxPagingNavigationLink(id, pageable, pageNumber){

            protected AjaxPagingNavigationBehavior newAjaxPagingNavigationBehavior(IPageable pageable, String event) {
                return new BootstrapAjaxPagingNavigationBehavior((IAjaxLink)this, pageable, event);
            }
        };
    }

    @Override
    protected PagingNavigation newNavigation(String id, IPageable pageable, IPagingLabelProvider labelProvider) {
        return new AjaxPagingNavigation(id, pageable, labelProvider){
            private final AttributeModifier activeAttribute;
            {
                this.activeAttribute = AttributeModifier.append((String)"class", (Serializable)((Object)"active"));
            }

            protected Link<?> newPagingNavigationLink(String id, IPageable pageable, long pageIndex) {
                return new AjaxPagingNavigationLink(id, pageable, pageIndex){

                    protected AjaxPagingNavigationBehavior newAjaxPagingNavigationBehavior(IPageable pageable, String event) {
                        return new BootstrapAjaxPagingNavigationBehavior((IAjaxLink)this, pageable, event);
                    }
                };
            }

            protected void populateItem(LoopItem loopItem) {
                super.populateItem(loopItem);
                if (this.getStartIndex() + (long)loopItem.getIndex() == this.pageable.getCurrentPage()) {
                    loopItem.add(new Behavior[]{this.activeAttribute});
                }
            }
        };
    }

    protected void onAjaxEvent(AjaxRequestTarget target) {
        Component container = (Component)this.pageable;
        while (container instanceof AbstractRepeater) {
            container = container.getParent();
        }
        target.add(new Component[]{container});
        if (!((MarkupContainer)container).contains((Component)this, true)) {
            target.add(new Component[]{this});
        }
    }
}

