/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.form;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.markup.html.bootstrap.layout.col.SpanType;
import de.agilecoders.wicket.core.util.Attributes;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;

public class InputBehavior
extends BootstrapBaseBehavior {
    private ICssClassNameProvider heightSize;
    private SpanType columnSize;

    public InputBehavior() {
        this(null, null);
    }

    public InputBehavior(SpanType columnSize) {
        this(null, columnSize);
    }

    public InputBehavior(Size heightSize) {
        this(heightSize, null);
    }

    public InputBehavior(Size heightSize, SpanType columnSize) {
        this.heightSize = heightSize;
        this.columnSize = columnSize;
    }

    public InputBehavior size(SpanType spanType) {
        this.columnSize = spanType;
        return this;
    }

    public InputBehavior size(Size heightSize) {
        this.heightSize = heightSize;
        return this;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        if (this.heightSize != null) {
            Attributes.addClass(tag, this.heightSize.cssClassName());
        }
        Attributes.addClass(tag, "form-control");
    }

    public void beforeRender(Component component) {
        super.beforeRender(component);
        if (this.columnSize != null) {
            component.getResponse().write((CharSequence)("<div class=\"" + this.columnSize.cssClassName() + "\">"));
        }
    }

    public void afterRender(Component component) {
        super.afterRender(component);
        if (this.columnSize != null) {
            component.getResponse().write((CharSequence)"</div>");
        }
    }

    public static enum Size implements ICssClassNameProvider
    {
        Small("sm"),
        Medium("md"),
        Large("lg");

        private final String cssName;

        private Size(String cssName) {
            this.cssName = cssName;
        }

        @Override
        public String cssClassName() {
            return this == Medium ? "" : "input-" + this.cssName;
        }
    }
}

