/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.button;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.IBootstrapButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.PanelMarkupSourcingStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class BootstrapAjaxButton
extends AjaxButton
implements IBootstrapButton<BootstrapAjaxButton> {
    private final Icon icon;
    private final Component label;
    private final Component splitter;
    private final ButtonBehavior buttonBehavior;
    private boolean useSplitter = true;

    public BootstrapAjaxButton(String componentId, Buttons.Type type) {
        this(componentId, (IModel<String>)new Model(), type);
    }

    public BootstrapAjaxButton(String componentId, IModel<String> model, Buttons.Type type) {
        this(componentId, model, null, type);
    }

    public BootstrapAjaxButton(String id, Form<?> form, Buttons.Type type) {
        this(id, (IModel<String>)Model.of(), form, type);
    }

    public BootstrapAjaxButton(String id, IModel<String> model, Form<?> form, Buttons.Type type) {
        super(id, model, form);
        Behavior[] behaviorArray = new Behavior[1];
        this.buttonBehavior = new ButtonBehavior(type, Buttons.Size.Medium);
        behaviorArray[0] = this.buttonBehavior;
        this.add(behaviorArray);
        Component[] componentArray = new Component[1];
        this.icon = this.newIcon("icon");
        componentArray[0] = this.icon;
        this.add(componentArray);
        this.splitter = this.newSplitter("splitter");
        this.add(new Component[]{this.splitter});
        this.label = this.newLabel("label", model);
        this.add(new Component[]{this.label});
    }

    protected Icon newIcon(String markupId) {
        return new Icon(markupId, (IconType)null);
    }

    protected <L extends Serializable> Component newLabel(String markupId, IModel<L> model) {
        return new Label(markupId, model).setRenderBodyOnly(true);
    }

    protected Component newSplitter(String markupId) {
        return new WebMarkupContainer(markupId).setRenderBodyOnly(true).setEscapeModelStrings(false).setVisible(false);
    }

    protected final IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return new PanelMarkupSourcingStrategy(true);
    }

    protected void onConfigure() {
        super.onConfigure();
        if (this.useSplitter) {
            this.splitter.setVisible(this.icon.hasIconType() && StringUtils.isNotEmpty((CharSequence)this.label.getDefaultModelObjectAsString()));
        }
    }

    public BootstrapAjaxButton setLabel(IModel<String> label) {
        this.label.setDefaultModel(label);
        return this;
    }

    public BootstrapAjaxButton setIconType(IconType iconType) {
        this.icon.setType(iconType);
        return this;
    }

    @Override
    public BootstrapAjaxButton setSize(Buttons.Size size) {
        this.buttonBehavior.setSize(size);
        return this;
    }

    @Override
    public BootstrapAjaxButton setType(Buttons.Type type) {
        this.buttonBehavior.setType(type);
        return this;
    }

    public BootstrapAjaxButton useSplitter(boolean value) {
        this.useSplitter = value;
        return this;
    }
}

