/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.javascript.IJavaScriptCompressor;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.PackageResource;
import org.apache.wicket.resource.IScopeAwareTextResourceProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptPackageResource
extends PackageResource {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(JavaScriptPackageResource.class);
    private final String name;

    public JavaScriptPackageResource(Class<?> scope, String name, Locale locale, String style, String variation) {
        super(scope, name, locale, style, variation);
        this.name = name;
        this.setCompress(!name.contains(".min."));
    }

    @Override
    protected byte[] processResponse(IResource.Attributes attributes, byte[] bytes) {
        byte[] processedResponse = super.processResponse(attributes, bytes);
        IJavaScriptCompressor compressor = this.getCompressor();
        if (compressor != null && this.getCompress()) {
            try {
                String output;
                String charsetName = "UTF-8";
                String nonCompressed = new String(processedResponse, charsetName);
                if (compressor instanceof IScopeAwareTextResourceProcessor) {
                    IScopeAwareTextResourceProcessor scopeAwareProcessor = (IScopeAwareTextResourceProcessor)((Object)compressor);
                    output = scopeAwareProcessor.process(nonCompressed, this.getScope(), this.name);
                } else {
                    output = compressor.compress(nonCompressed);
                }
                return output.getBytes(charsetName);
            }
            catch (Exception e) {
                log.error("Error while filtering content", (Throwable)e);
                return processedResponse;
            }
        }
        return processedResponse;
    }

    protected IJavaScriptCompressor getCompressor() {
        IJavaScriptCompressor compressor = null;
        if (Application.exists()) {
            compressor = Application.get().getResourceSettings().getJavaScriptCompressor();
        }
        return compressor;
    }
}

