/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.annotations.Resource;
import org.apache.syncope.client.enduser.resources.BaseResource;
import org.apache.syncope.common.lib.to.SAML2IdPTO;
import org.apache.syncope.common.rest.api.service.SAML2IdPService;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;

@Resource(key="saml2IdPs", path="/api/saml2IdPs")
public class SAML2IdPsResource
extends BaseResource {
    private static final long serialVersionUID = -1538214102767503491L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setContentType("application/json");
        response.setTextEncoding(StandardCharsets.UTF_8.name());
        try {
            final ArrayNode result = MAPPER.createArrayNode();
            for (SAML2IdPTO idp : ((SAML2IdPService)SyncopeEnduserSession.get().getService(SAML2IdPService.class)).list()) {
                ObjectNode idpNode = MAPPER.createObjectNode();
                idpNode.put("name", idp.getName());
                idpNode.put("entityID", idp.getEntityID());
                idpNode.put("logout", idp.isLogoutSupported());
                result.add((JsonNode)idpNode);
            }
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)BaseResource.MAPPER.writeValueAsString((Object)result));
                }
            });
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error retrieving available SAML 2.0 Identity Providers", (Throwable)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + "}}");
        }
        return response;
    }
}

