/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import java.util.regex.Pattern;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.RealmCheck;
import org.apache.syncope.core.provisioning.api.LogicActions;

public class RealmValidator
extends AbstractValidator<RealmCheck, Realm> {
    private static final Pattern REALM_NAME_PATTERN = Pattern.compile("^[A-Za-z0-9]+");

    public boolean isValid(Realm realm, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean isValid = true;
        if ("/".equals(realm.getName())) {
            if (realm.getParent() != null) {
                isValid = false;
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidRealm, "Root realm cannot have a parent realm")).addPropertyNode("parent").addConstraintViolation();
            }
        } else {
            if (realm.getParent() == null) {
                isValid = false;
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidRealm, "A realm needs to reference a parent realm")).addPropertyNode("parent").addConstraintViolation();
            }
            if (!REALM_NAME_PATTERN.matcher(realm.getName()).matches()) {
                isValid = false;
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidRealm, "Only letters and numbers are allowed in realm name")).addPropertyNode("name").addConstraintViolation();
            }
        }
        if (!realm.getActionsClassNames().isEmpty()) {
            for (String className : realm.getActionsClassNames()) {
                Class<?> actionsClass = null;
                boolean isAssignable = false;
                try {
                    actionsClass = Class.forName(className);
                    isAssignable = LogicActions.class.isAssignableFrom(actionsClass);
                }
                catch (Exception e) {
                    LOG.error("Invalid {} specified", (Object)LogicActions.class.getName(), (Object)e);
                    isValid = false;
                }
                if (actionsClass != null && isAssignable) continue;
                isValid = false;
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidRealm, "Invalid class name")).addPropertyNode("actionsClassName").addConstraintViolation();
            }
        }
        return isValid;
    }
}

